/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CompoundCondition;
import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.ThresholdSha256Condition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;

public final class ImmutableThresholdSha256Condition
extends ThresholdSha256Condition.AbstractThresholdSha256Condition {
    private final CryptoConditionType type;
    private final byte[] fingerprint;
    private final String fingerprintBase64Url;
    private final long cost;
    private final EnumSet<CryptoConditionType> subtypes;

    private ImmutableThresholdSha256Condition(CryptoConditionType type, byte[] fingerprint, String fingerprintBase64Url, long cost, EnumSet<CryptoConditionType> subtypes) {
        this.type = type;
        this.fingerprint = fingerprint;
        this.fingerprintBase64Url = fingerprintBase64Url;
        this.cost = cost;
        this.subtypes = subtypes;
    }

    @Override
    public CryptoConditionType getType() {
        return this.type;
    }

    @Override
    @Deprecated
    public byte[] getFingerprint() {
        return (byte[])this.fingerprint.clone();
    }

    @Override
    public String getFingerprintBase64Url() {
        return this.fingerprintBase64Url;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public EnumSet<CryptoConditionType> getSubtypes() {
        return this.subtypes;
    }

    public final ImmutableThresholdSha256Condition withType(CryptoConditionType value) {
        if (this.type == value) {
            return this;
        }
        CryptoConditionType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableThresholdSha256Condition(newValue, this.fingerprint, this.fingerprintBase64Url, this.cost, this.subtypes);
    }

    @Deprecated
    public final ImmutableThresholdSha256Condition withFingerprint(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableThresholdSha256Condition(this.type, newValue, this.fingerprintBase64Url, this.cost, this.subtypes);
    }

    public final ImmutableThresholdSha256Condition withFingerprintBase64Url(String value) {
        if (this.fingerprintBase64Url.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "fingerprintBase64Url");
        return new ImmutableThresholdSha256Condition(this.type, this.fingerprint, newValue, this.cost, this.subtypes);
    }

    public final ImmutableThresholdSha256Condition withCost(long value) {
        if (this.cost == value) {
            return this;
        }
        return new ImmutableThresholdSha256Condition(this.type, this.fingerprint, this.fingerprintBase64Url, value, this.subtypes);
    }

    public final ImmutableThresholdSha256Condition withSubtypes(EnumSet<CryptoConditionType> value) {
        if (this.subtypes == value) {
            return this;
        }
        EnumSet<CryptoConditionType> newValue = Objects.requireNonNull(value, "subtypes");
        return new ImmutableThresholdSha256Condition(this.type, this.fingerprint, this.fingerprintBase64Url, this.cost, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThresholdSha256Condition && this.equalTo((ImmutableThresholdSha256Condition)another);
    }

    private boolean equalTo(ImmutableThresholdSha256Condition another) {
        return this.type.equals((Object)another.type) && Arrays.equals(this.fingerprint, another.fingerprint) && this.fingerprintBase64Url.equals(another.fingerprintBase64Url) && this.cost == another.cost && this.subtypes.equals(another.subtypes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Arrays.hashCode(this.fingerprint);
        h += (h << 5) + this.fingerprintBase64Url.hashCode();
        h += (h << 5) + Long.hashCode(this.cost);
        h += (h << 5) + this.subtypes.hashCode();
        return h;
    }

    public static ImmutableThresholdSha256Condition copyOf(ThresholdSha256Condition.AbstractThresholdSha256Condition instance) {
        if (instance instanceof ImmutableThresholdSha256Condition) {
            return (ImmutableThresholdSha256Condition)instance;
        }
        return ImmutableThresholdSha256Condition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_FINGERPRINT = 2L;
        private static final long INIT_BIT_FINGERPRINT_BASE64_URL = 4L;
        private static final long INIT_BIT_COST = 8L;
        private static final long INIT_BIT_SUBTYPES = 16L;
        private long initBits = 31L;
        private CryptoConditionType type;
        private byte[] fingerprint;
        private String fingerprintBase64Url;
        private long cost;
        private EnumSet<CryptoConditionType> subtypes;

        private Builder() {
        }

        public final Builder from(CompoundCondition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Condition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ThresholdSha256Condition.AbstractThresholdSha256Condition instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Condition instance;
            if (object instanceof CompoundCondition) {
                instance = (CompoundCondition)object;
                this.subtypes(instance.getSubtypes());
            }
            if (object instanceof Condition) {
                instance = (Condition)object;
                this.fingerprint(instance.getFingerprint());
                this.fingerprintBase64Url(instance.getFingerprintBase64Url());
                this.cost(instance.getCost());
                this.type(instance.getType());
            }
        }

        public final Builder type(CryptoConditionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        public final Builder fingerprint(byte ... fingerprint) {
            this.fingerprint = (byte[])fingerprint.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fingerprintBase64Url(String fingerprintBase64Url) {
            this.fingerprintBase64Url = Objects.requireNonNull(fingerprintBase64Url, "fingerprintBase64Url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder cost(long cost) {
            this.cost = cost;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder subtypes(EnumSet<CryptoConditionType> subtypes) {
            this.subtypes = Objects.requireNonNull(subtypes, "subtypes");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableThresholdSha256Condition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableThresholdSha256Condition(this.type, this.fingerprint, this.fingerprintBase64Url, this.cost, this.subtypes);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fingerprint");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("fingerprintBase64Url");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("cost");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("subtypes");
            }
            return "Cannot build ThresholdSha256Condition, some of required attributes are not set " + attributes;
        }
    }
}

