/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class NamedInformationUri {
    public static final String SCHEME = "ni";
    public static final String SCHEME_PREFIX = "ni://";

    public static URI getUri(HashFunction hashFunction, byte[] hash, Map<String, String> queryStringParams) {
        Objects.requireNonNull(hashFunction);
        Objects.requireNonNull(hash);
        Objects.requireNonNull(queryStringParams);
        StringBuilder sb = new StringBuilder();
        sb.append(SCHEME_PREFIX).append("/").append(hashFunction.getName()).append(";").append(Base64.getUrlEncoder().withoutPadding().encodeToString(hash));
        if (!queryStringParams.isEmpty()) {
            sb.append("?");
            queryStringParams.forEach((key, value) -> {
                if (value != null && !"".equals(value)) {
                    String encodedValue = Optional.ofNullable(value).filter(val -> val.contains(",")).map(valueWithComma -> Arrays.asList(value.split(",")).stream()).map(stringStream -> stringStream.filter(v -> v != "").map(NamedInformationUri::encode).distinct().collect(Collectors.joining(","))).orElseGet(() -> NamedInformationUri.encode(value));
                    sb.append((String)key).append("=").append(encodedValue);
                    sb.append("&");
                }
            });
            sb.deleteCharAt(sb.length() - 1);
        }
        return URI.create(sb.toString());
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getHashFunctionRegexGroup() {
        return "(" + String.join((CharSequence)"|", (CharSequence[])Arrays.stream(HashFunction.values()).map(s -> s.getName()).toArray(String[]::new)) + ")";
    }

    public static enum HashFunction {
        MD2("md2", "1.2.840.113549.2.2"),
        MD5("md5", "1.2.840.113549.2.5"),
        SHA_1("sha-1", "1.3.14.3.2.26"),
        SHA_224("sha-224", "2.16.840.1.101.3.4.2.4"),
        SHA_256("sha-256", "2.16.840.1.101.3.4.2.1"),
        SHA_384("sha-384", "2.16.840.1.101.3.4.2.2"),
        SHA_512("sha-512", "2.16.840.1.101.3.4.2.3");

        private String name;
        private String oid;

        private HashFunction(String name, String oid) {
            this.name = name;
            this.oid = oid;
        }

        public String getName() {
            return this.name;
        }

        public String getOid() {
            return this.oid;
        }
    }
}

