/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CompoundCondition;
import com.ripple.cryptoconditions.CompoundSha256Condition;
import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.ConditionBase;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.CryptoConditionWriter;
import com.ripple.cryptoconditions.ImmutablePrefixSha256Condition;
import com.ripple.cryptoconditions.der.DerEncodingException;
import com.ripple.cryptoconditions.der.DerOutputStream;
import com.ripple.cryptoconditions.der.DerTag;
import com.ripple.cryptoconditions.utils.HashUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Objects;
import org.immutables.value.Value;

public interface PrefixSha256Condition
extends CompoundSha256Condition {
    public static PrefixSha256Condition from(byte[] prefix, long maxMessageLength, Condition subcondition) {
        long cost = AbstractPrefixSha256Condition.calculateCost(prefix, maxMessageLength, subcondition.getCost());
        byte[] fingerprint = HashUtils.hashFingerprintContents(AbstractPrefixSha256Condition.constructFingerprintContents(prefix, maxMessageLength, subcondition));
        EnumSet<CryptoConditionType> subtypes = AbstractPrefixSha256Condition.calculateSubtypes(subcondition);
        return ImmutablePrefixSha256Condition.builder().type(CryptoConditionType.PREFIX_SHA256).cost(cost).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).subtypes(subtypes).build();
    }

    public static PrefixSha256Condition fromCostAndFingerprint(long cost, byte[] fingerprint, EnumSet<CryptoConditionType> subtypes) {
        Objects.requireNonNull(fingerprint);
        return ImmutablePrefixSha256Condition.builder().type(CryptoConditionType.PREFIX_SHA256).cost(cost).fingerprint(fingerprint).subtypes(subtypes).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).build();
    }

    @Value.Immutable
    public static abstract class AbstractPrefixSha256Condition
    extends ConditionBase<PrefixSha256Condition>
    implements PrefixSha256Condition {
        static final byte[] constructFingerprintContents(byte[] prefix, long maxMessageLength, Condition subcondition) {
            Objects.requireNonNull(prefix);
            Objects.requireNonNull(subcondition);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DerOutputStream out = new DerOutputStream(baos);
                out.writeTaggedObject(0, prefix);
                out.writeTaggedObject(1, BigInteger.valueOf(maxMessageLength).toByteArray());
                out.writeTaggedConstructedObject(2, CryptoConditionWriter.writeCondition(subcondition));
                out.close();
                byte[] buffer = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                out = new DerOutputStream(baos);
                out.writeEncoded(DerTag.CONSTRUCTED.getTag() + DerTag.SEQUENCE.getTag(), buffer);
                out.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException("DER Encoding Error", e);
            }
            catch (DerEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        static final long calculateCost(byte[] prefix, long maxMessageLength, long subconditionCost) {
            return (long)Objects.requireNonNull(prefix).length + maxMessageLength + subconditionCost + 1024L;
        }

        static EnumSet<CryptoConditionType> calculateSubtypes(Condition subcondition) {
            Objects.requireNonNull(subcondition);
            EnumSet<CryptoConditionType> subtypes = EnumSet.of(subcondition.getType());
            if (subcondition instanceof CompoundCondition) {
                subtypes.addAll(((CompoundCondition)subcondition).getSubtypes());
            }
            if (subtypes.contains((Object)CryptoConditionType.PREFIX_SHA256)) {
                subtypes.remove((Object)CryptoConditionType.PREFIX_SHA256);
            }
            return subtypes;
        }

        public String toString() {
            return "PrefixSha256Condition{subtypes=" + this.getSubtypes() + ", type=" + (Object)((Object)this.getType()) + ", fingerprint=" + this.getFingerprintBase64Url() + ", cost=" + this.getCost() + "}";
        }
    }
}

