/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.ConditionBase;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.ImmutablePreimageSha256Condition;
import com.ripple.cryptoconditions.Sha256Condition;
import java.util.Base64;
import java.util.Objects;
import org.immutables.value.Value;

public interface PreimageSha256Condition
extends Sha256Condition {
    public static PreimageSha256Condition fromCostAndFingerprint(long cost, byte[] fingerprint) {
        Objects.requireNonNull(fingerprint);
        return ImmutablePreimageSha256Condition.builder().type(CryptoConditionType.PREIMAGE_SHA256).cost(cost).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).build();
    }

    @Value.Immutable
    public static abstract class AbstractPreimageSha256Condition
    extends ConditionBase<PreimageSha256Condition>
    implements PreimageSha256Condition {
        public String toString() {
            return "PreimageSha256Condition{type=" + (Object)((Object)this.getType()) + ", fingerprint=" + this.getFingerprintBase64Url() + ", cost=" + this.getCost() + "}";
        }
    }
}

