/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CompoundCondition;
import com.ripple.cryptoconditions.CompoundSha256Condition;
import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.ConditionBase;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.CryptoConditionWriter;
import com.ripple.cryptoconditions.ImmutableThresholdSha256Condition;
import com.ripple.cryptoconditions.der.DerEncodingException;
import com.ripple.cryptoconditions.der.DerOutputStream;
import com.ripple.cryptoconditions.der.DerTag;
import com.ripple.cryptoconditions.utils.HashUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Base64;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public interface ThresholdSha256Condition
extends CompoundSha256Condition {
    public static ThresholdSha256Condition from(int threshold, List<Condition> subconditions) {
        Objects.requireNonNull(subconditions);
        List<Condition> immutableSubconditions = subconditions.stream().collect(Collectors.toList());
        if (threshold > immutableSubconditions.size()) {
            throw new IllegalArgumentException("Threshold must be less than or equal to the number of subconditions!");
        }
        long cost = AbstractThresholdSha256Condition.calculateCost(threshold, immutableSubconditions);
        byte[] fingerprint = HashUtils.hashFingerprintContents(AbstractThresholdSha256Condition.constructFingerprintContents(threshold, immutableSubconditions));
        return ImmutableThresholdSha256Condition.builder().type(CryptoConditionType.THRESHOLD_SHA256).cost(cost).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).subtypes(AbstractThresholdSha256Condition.calculateSubtypes(immutableSubconditions)).build();
    }

    public static ThresholdSha256Condition fromCostAndFingerprint(long cost, byte[] fingerprint, EnumSet<CryptoConditionType> subtypes) {
        Objects.requireNonNull(fingerprint);
        return ImmutableThresholdSha256Condition.builder().type(CryptoConditionType.THRESHOLD_SHA256).cost(cost).fingerprint(fingerprint).fingerprintBase64Url(Base64.getUrlEncoder().withoutPadding().encodeToString(fingerprint)).subtypes(subtypes).build();
    }

    @Value.Immutable
    public static abstract class AbstractThresholdSha256Condition
    extends ConditionBase<ThresholdSha256Condition>
    implements ThresholdSha256Condition {
        static final byte[] constructFingerprintContents(int threshold, List<Condition> subconditions) {
            try {
                AbstractThresholdSha256Condition.sortConditions(subconditions);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DerOutputStream out = new DerOutputStream(baos);
                for (int i = 0; i < subconditions.size(); ++i) {
                    out.write(CryptoConditionWriter.writeCondition(subconditions.get(i)));
                }
                out.close();
                byte[] subconditionBuffer = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                out = new DerOutputStream(baos);
                out.writeTaggedObject(0, BigInteger.valueOf(threshold).toByteArray());
                out.writeTaggedConstructedObject(1, subconditionBuffer);
                out.close();
                byte[] thresholdBuffer = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                out = new DerOutputStream(baos);
                out.writeEncoded(DerTag.CONSTRUCTED.getTag() + DerTag.SEQUENCE.getTag(), thresholdBuffer);
                out.close();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException("DER Encoding Error", e);
            }
            catch (DerEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private static final void sortConditions(List<Condition> conditions) {
            Objects.requireNonNull(conditions);
            conditions.sort((c1, c2) -> {
                try {
                    byte[] c1encoded = CryptoConditionWriter.writeCondition(c1);
                    byte[] c2encoded = CryptoConditionWriter.writeCondition(c2);
                    int minLength = Math.min(c1encoded.length, c2encoded.length);
                    for (int i = 0; i < minLength; ++i) {
                        int result = Integer.compareUnsigned(c1encoded[i], c2encoded[i]);
                        if (result == 0) continue;
                        return result;
                    }
                    return c1encoded.length - c2encoded.length;
                }
                catch (DerEncodingException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        static final long calculateCost(int threshold, List<Condition> subconditions) {
            Objects.requireNonNull(subconditions);
            List sortedSubconditions = subconditions.stream().sorted((c1, c2) -> (int)(c2.getCost() - c1.getCost())).collect(Collectors.toList());
            long largestCosts = 0L;
            for (int i = 0; i < threshold; ++i) {
                largestCosts += ((Condition)sortedSubconditions.get(i)).getCost();
            }
            return largestCosts + (long)(sortedSubconditions.size() * 1024);
        }

        static final EnumSet<CryptoConditionType> calculateSubtypes(List<Condition> subconditions) {
            Objects.requireNonNull(subconditions);
            EnumSet<CryptoConditionType> subtypes = EnumSet.noneOf(CryptoConditionType.class);
            for (int i = 0; i < subconditions.size(); ++i) {
                subtypes.add(subconditions.get(i).getType());
                if (!(subconditions.get(i) instanceof CompoundCondition)) continue;
                subtypes.addAll(((CompoundCondition)subconditions.get(i)).getSubtypes());
            }
            if (subtypes.contains((Object)CryptoConditionType.THRESHOLD_SHA256)) {
                subtypes.remove((Object)CryptoConditionType.THRESHOLD_SHA256);
            }
            return subtypes;
        }

        public String toString() {
            return "ThresholdSha256Condition{subtypes=" + this.getSubtypes() + ", type=" + (Object)((Object)this.getType()) + ", fingerprint=" + this.getFingerprintBase64Url() + ", cost=" + this.getCost() + "}";
        }
    }
}

