/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions.utils;

import java.math.BigInteger;
import java.util.Arrays;

public class UnsignedBigInteger {
    public static byte[] toUnsignedByteArray(BigInteger value) {
        if (value.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Value must be >= 0.");
        }
        byte[] signedValue = value.toByteArray();
        if (signedValue[0] == 0) {
            return Arrays.copyOfRange(signedValue, 1, signedValue.length);
        }
        return signedValue;
    }

    public static BigInteger fromUnsignedByteArray(byte[] value) {
        return new BigInteger(1, value);
    }
}

