/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization;

import com.ritense.authorization.Action;
import com.ritense.authorization.AuthorizationContext;
import com.ritense.authorization.AuthorizationEntityMapper;
import com.ritense.authorization.AuthorizationService;
import com.ritense.authorization.ResourceActionProvider;
import com.ritense.authorization.ValtimoAuthorizationService;
import com.ritense.authorization.permission.Permission;
import com.ritense.authorization.permission.PermissionRepository;
import com.ritense.authorization.request.AuthorizationRequest;
import com.ritense.authorization.role.Role;
import com.ritense.authorization.specification.AuthorizationSpecification;
import com.ritense.authorization.specification.AuthorizationSpecificationFactory;
import com.ritense.valtimo.contract.authentication.ManageableUser;
import com.ritense.valtimo.contract.authentication.UserManagementService;
import com.ritense.valtimo.contract.utils.SecurityUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.access.AccessDeniedException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,BO\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0003\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ<\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0003H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0016J,\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u001c0\u0003\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00100\u001eH\u0016J<\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H!0\u0006\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0\u001eH\u0016J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u001e2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016J \u0010(\u001a\u00020\u0017\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0016J\"\u0010)\u001a\u00020*2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003H\u0002J \u0010+\u001a\u00020*\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0016R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/ritense/authorization/ValtimoAuthorizationService;", "Lcom/ritense/authorization/AuthorizationService;", "authorizationSpecificationFactories", "", "Lcom/ritense/authorization/specification/AuthorizationSpecificationFactory;", "mappers", "Lcom/ritense/authorization/AuthorizationEntityMapper;", "actionProviders", "Lcom/ritense/authorization/ResourceActionProvider;", "permissionRepository", "Lcom/ritense/authorization/permission/PermissionRepository;", "userManagementService", "Lcom/ritense/valtimo/contract/authentication/UserManagementService;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/ritense/authorization/permission/PermissionRepository;Lcom/ritense/valtimo/contract/authentication/UserManagementService;)V", "getAuthorizationSpecification", "Lcom/ritense/authorization/specification/AuthorizationSpecification;", "T", "", "request", "Lcom/ritense/authorization/request/AuthorizationRequest;", "permissions", "Lcom/ritense/authorization/permission/Permission;", "enablePermissionLogging", "", "getAuthorizedRoles", "", "Lcom/ritense/authorization/role/Role;", "getAvailableActionsForResource", "Lcom/ritense/authorization/Action;", "clazz", "Ljava/lang/Class;", "getMapper", "FROM", "TO", "from", "to", "getPermissions", "context", "resourceType", "action", "hasPermission", "logPermissions", "", "requirePermission", "Companion", "authorization"})
@SourceDebugExtension(value={"SMAP\nValtimoAuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValtimoAuthorizationService.kt\ncom/ritense/authorization/ValtimoAuthorizationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,154:1\n1477#2:155\n1502#2,3:156\n1505#2,3:166\n288#2,2:180\n766#2:182\n857#2,2:183\n1549#2:185\n1620#2,3:186\n1549#2:189\n1620#2,3:190\n288#2,2:193\n766#2:195\n857#2,2:196\n361#3,7:159\n515#3:169\n500#3,6:170\n125#4:176\n152#4,3:177\n*S KotlinDebug\n*F\n+ 1 ValtimoAuthorizationService.kt\ncom/ritense/authorization/ValtimoAuthorizationService\n*L\n51#1:155\n51#1:156,3\n51#1:166,3\n85#1:180,2\n93#1:182\n93#1:183,2\n94#1:185\n94#1:186,3\n95#1:189\n95#1:190,3\n108#1:193,2\n124#1:195\n124#1:196,2\n51#1:159,7\n52#1:169\n52#1:170,6\n53#1:176\n53#1:177,3\n*E\n"})
public final class ValtimoAuthorizationService
implements AuthorizationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AuthorizationSpecificationFactory<?>> authorizationSpecificationFactories;
    @NotNull
    private final List<AuthorizationEntityMapper<?, ?>> mappers;
    @NotNull
    private final List<ResourceActionProvider<?>> actionProviders;
    @NotNull
    private final PermissionRepository permissionRepository;
    @NotNull
    private final UserManagementService userManagementService;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    public ValtimoAuthorizationService(@NotNull List<? extends AuthorizationSpecificationFactory<?>> authorizationSpecificationFactories, @NotNull List<? extends AuthorizationEntityMapper<?, ?>> mappers, @NotNull List<? extends ResourceActionProvider<?>> actionProviders, @NotNull PermissionRepository permissionRepository, @NotNull UserManagementService userManagementService) {
        Intrinsics.checkNotNullParameter(authorizationSpecificationFactories, (String)"authorizationSpecificationFactories");
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        Intrinsics.checkNotNullParameter(actionProviders, (String)"actionProviders");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        Intrinsics.checkNotNullParameter((Object)userManagementService, (String)"userManagementService");
        this.authorizationSpecificationFactories = authorizationSpecificationFactories;
        this.mappers = mappers;
        this.actionProviders = actionProviders;
        this.permissionRepository = permissionRepository;
        this.userManagementService = userManagementService;
    }

    @Override
    public <T> void requirePermission(@NotNull AuthorizationRequest<T> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        if (!this.hasPermission(request)) {
            if (!Intrinsics.areEqual((Object)request.getAction().getKey(), (Object)"deny")) {
                logger.debug((Function0)new Function0<Object>(request){
                    final /* synthetic */ AuthorizationRequest<T> $request;
                    {
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unauthorized. User is missing permission '" + this.$request.getAction().getKey() + "' on '" + this.$request.getResourceType() + "'.";
                    }
                });
            }
            throw new AccessDeniedException("Unauthorized");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Set<Role> getAuthorizedRoles(@NotNull AuthorizationRequest<T> request) {
        void $this$mapTo$iv$iv;
        Map $this$filterTo$iv$iv;
        boolean bl;
        Object it;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Iterable $this$groupBy$iv = this.getPermissions(request.getResourceType(), request.getAction());
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t = iterator.next();
            it = (Permission)t;
            bl = false;
            Role key$iv$iv = ((Permission)it).getRole();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!this.getAuthorizationSpecification(request, (List)it.getValue(), false).isAuthorized$authorization()) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            it = entry;
            Object object = destination$iv$iv;
            bl = false;
            object.add((Role)it.getKey());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    public <T> boolean hasPermission(@NotNull AuthorizationRequest<T> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        return AuthorizationService.DefaultImpls.getAuthorizationSpecification$default(this, request, null, 2, null).isAuthorized$authorization();
    }

    @Override
    @NotNull
    public <T> AuthorizationSpecification<T> getAuthorizationSpecification(@NotNull AuthorizationRequest<T> request, @Nullable List<Permission> permissions) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        List<Permission> list = permissions;
        if (list == null) {
            list = this.getPermissions(request);
        }
        List<Permission> usedPermissions = list;
        return this.getAuthorizationSpecification(request, usedPermissions, true);
    }

    @Override
    @NotNull
    public List<Permission> getPermissions(@NotNull Class<?> resourceType, @NotNull Action<?> action) {
        Intrinsics.checkNotNullParameter(resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.permissionRepository.findAllByResourceTypeAndAction(resourceType, action);
    }

    @Override
    @NotNull
    public <FROM, TO> AuthorizationEntityMapper<FROM, TO> getMapper(@NotNull Class<FROM> from, @NotNull Class<TO> to) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            Intrinsics.checkNotNullParameter(to, (String)"to");
            Iterable $this$firstOrNull$iv = this.mappers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AuthorizationEntityMapper it = (AuthorizationEntityMapper)element$iv;
                boolean bl = false;
                if (!it.supports(from, to)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        AuthorizationEntityMapper authorizationEntityMapper = v0;
        if (authorizationEntityMapper == null) {
            throw new AccessDeniedException("No entity mapper found for given arguments.");
        }
        return authorizationEntityMapper;
    }

    @Override
    @NotNull
    public <T> List<Action<T>> getAvailableActionsForResource(@NotNull Class<T> clazz) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        ResourceActionProvider it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterable $this$filter$iv = this.actionProviders;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceActionProvider)element$iv$iv;
            boolean bl = false;
            Type type = it.getClass().getGenericInterfaces()[0];
            Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
            if (!((ParameterizedType)type).getActualTypeArguments()[0].equals(clazz)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceActionProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.ritense.authorization.ResourceActionProvider<T of com.ritense.authorization.ValtimoAuthorizationService.getAvailableActionsForResource$lambda$5>");
            collection.add(it);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceActionProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAvailableActions());
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    private final <T> AuthorizationSpecification<T> getAuthorizationSpecification(AuthorizationRequest<T> request, List<Permission> permissions, boolean enablePermissionLogging) {
        Object v0;
        block3: {
            if (enablePermissionLogging) {
                this.logPermissions(request, permissions);
            }
            Iterable $this$firstOrNull$iv = this.authorizationSpecificationFactories;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AuthorizationSpecificationFactory it = (AuthorizationSpecificationFactory)element$iv;
                boolean bl = false;
                if (!it.canCreate(request, permissions)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        AuthorizationSpecificationFactory authorizationSpecificationFactory = v0;
        if (authorizationSpecificationFactory == null) {
            throw new AccessDeniedException("No specification found for given context.");
        }
        AuthorizationSpecificationFactory factory = authorizationSpecificationFactory;
        return factory.create(request, permissions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Permission> getPermissions(AuthorizationRequest<?> context) {
        void $this$filterTo$iv$iv;
        List list;
        if (context.getUser() == null || Intrinsics.areEqual((Object)context.getUser(), (Object)SecurityUtils.getCurrentUserLogin())) {
            list = SecurityUtils.getCurrentUserRoles();
        } else {
            List list2;
            ManageableUser manageableUser = this.userManagementService.findByEmail(context.getUser()).orElse(null);
            List list3 = list2 = manageableUser != null ? manageableUser.getRoles() : null;
            if (list2 == null) {
                return CollectionsKt.emptyList();
            }
            list = list2;
        }
        List userRoles = list;
        Intrinsics.checkNotNullExpressionValue((Object)userRoles, (String)"userRoles");
        Iterable $this$filter$iv = this.permissionRepository.findAllByRoleKeyInOrderByRoleKeyAscResourceTypeAsc(userRoles);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Permission permission = (Permission)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(context.getResourceType(), permission.getResourceType()) && Intrinsics.areEqual(context.getAction(), permission.getAction()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void logPermissions(AuthorizationRequest<?> request, List<Permission> permissions) {
        if (!AuthorizationContext.Companion.getIgnoreAuthorization()) {
            if (Intrinsics.areEqual((Object)request.getAction().getKey(), (Object)"deny")) {
                logger.error((Function0)new Function0<Object>(request){
                    final /* synthetic */ AuthorizationRequest<?> $request;
                    {
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Access denied on '" + this.$request.getResourceType() + "'. This generally indicates attempting to access a resource without considering authorization. Please refer to the Valtimo documentation.";
                    }
                });
            } else {
                String permissionsLogLine2 = CollectionsKt.joinToString$default((Iterable)permissions, (CharSequence)", ", null, null, (int)0, null, (Function1)logPermissions.permissionsLogLine.1.INSTANCE, (int)30, null);
                String logLine = "Requesting permissions '" + request.getAction().getKey() + ":" + request.getResourceType().getSimpleName() + "' for user '" + request.getUser() + "' and found matching permissions: [" + permissionsLogLine2 + "]";
                logger.debug((Function0)new Function0<Object>(logLine){
                    final /* synthetic */ String $logLine;
                    {
                        this.$logLine = $logLine;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$logLine;
                    }
                });
            }
        } else if (!Intrinsics.areEqual((Object)request.getAction().getKey(), (Object)"deny")) {
            String logLine = "Ignoring authorization request for '" + request.getAction().getKey() + ":" + request.getResourceType().getSimpleName() + "' for user '" + request.getUser() + "'. ";
            logger.debug((Function0)new Function0<Object>(logLine){
                final /* synthetic */ String $logLine;
                {
                    this.$logLine = $logLine;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$logLine;
                }
            });
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ritense/authorization/ValtimoAuthorizationService$Companion;", "", "()V", "logger", "Lmu/KLogger;", "authorization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

