/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization.autoconfigure;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ritense.authorization.AuthorizationEntityMapper;
import com.ritense.authorization.AuthorizationService;
import com.ritense.authorization.AuthorizationServiceHolder;
import com.ritense.authorization.AuthorizationSupportedHelper;
import com.ritense.authorization.ResourceActionProvider;
import com.ritense.authorization.UserManagementServiceHolder;
import com.ritense.authorization.ValtimoAuthorizationService;
import com.ritense.authorization.annotation.RunWithoutAuthorizationAspect;
import com.ritense.authorization.autoconfigure.PermissionConditionTypeModule;
import com.ritense.authorization.deployment.PermissionDeployer;
import com.ritense.authorization.deployment.RoleDeployer;
import com.ritense.authorization.permission.PermissionRepository;
import com.ritense.authorization.role.RoleRepository;
import com.ritense.authorization.specification.AuthorizationSpecificationFactory;
import com.ritense.authorization.specification.impl.DenyAuthorizationSpecificationFactory;
import com.ritense.authorization.specification.impl.NoopAuthorizationSpecificationFactory;
import com.ritense.authorization.web.PermissionManagementResource;
import com.ritense.authorization.web.PermissionResource;
import com.ritense.authorization.web.RoleManagementResource;
import com.ritense.authorization.web.security.ValtimoAuthorizationHttpSecurityConfigurer;
import com.ritense.valtimo.changelog.service.ChangelogService;
import com.ritense.valtimo.contract.authentication.UserManagementService;
import com.ritense.valtimo.contract.config.LiquibaseMasterChangeLogLocation;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableJpaRepositories(basePackages={"com.ritense.authorization"})
@EntityScan(value={"com.ritense.authorization"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\u0001H\u0017J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\u0001H\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0017J*\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010%\u001a\u00020&H\u0017J\b\u0010'\u001a\u00020(H\u0017JZ\u0010)\u001a\u00020 2\u0010\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0+2\u0014\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-0+2\u0010\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0+2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0017\u00a8\u00060"}, d2={"Lcom/ritense/authorization/autoconfigure/AuthorizationAutoConfiguration;", "", "userManagementService", "Lcom/ritense/valtimo/contract/authentication/UserManagementService;", "(Lcom/ritense/valtimo/contract/authentication/UserManagementService;)V", "authorizationLiquibaseMasterChangeLogLocation", "Lcom/ritense/valtimo/contract/config/LiquibaseMasterChangeLogLocation;", "authorizationSupportedHelper", "Lcom/ritense/authorization/AuthorizationSupportedHelper;", "denyAuthorizationSpecificationFactory", "Lcom/ritense/authorization/specification/AuthorizationSpecificationFactory;", "T", "noopAuthorizationSpecificationFactory", "permissionConditionTypeModule", "Lcom/fasterxml/jackson/databind/Module;", "permissionDeployer", "Lcom/ritense/authorization/deployment/PermissionDeployer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "permissionRepository", "Lcom/ritense/authorization/permission/PermissionRepository;", "roleRepository", "Lcom/ritense/authorization/role/RoleRepository;", "changelogService", "Lcom/ritense/valtimo/changelog/service/ChangelogService;", "clearTables", "", "permissionManagementResource", "Lcom/ritense/authorization/web/PermissionManagementResource;", "permissionResource", "Lcom/ritense/authorization/web/PermissionResource;", "authorizationService", "Lcom/ritense/authorization/AuthorizationService;", "roleDeployer", "Lcom/ritense/authorization/deployment/RoleDeployer;", "roleManagementResource", "Lcom/ritense/authorization/web/RoleManagementResource;", "runWithoutAuthorizationAspect", "Lcom/ritense/authorization/annotation/RunWithoutAuthorizationAspect;", "valtimoAuthorizationHttpSecurityConfigurer", "Lcom/ritense/authorization/web/security/ValtimoAuthorizationHttpSecurityConfigurer;", "valtimoAuthorizationService", "authorizationSpecificationFactories", "", "mappers", "Lcom/ritense/authorization/AuthorizationEntityMapper;", "actionProviders", "Lcom/ritense/authorization/ResourceActionProvider;", "authorization"})
public class AuthorizationAutoConfiguration {
    public AuthorizationAutoConfiguration(@NotNull UserManagementService userManagementService) {
        Intrinsics.checkNotNullParameter((Object)userManagementService, (String)"userManagementService");
        new UserManagementServiceHolder(userManagementService);
    }

    @Order(value=270)
    @Bean
    @ConditionalOnMissingBean(value={ValtimoAuthorizationHttpSecurityConfigurer.class})
    @NotNull
    public ValtimoAuthorizationHttpSecurityConfigurer valtimoAuthorizationHttpSecurityConfigurer() {
        return new ValtimoAuthorizationHttpSecurityConfigurer();
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorizationService.class})
    @NotNull
    public AuthorizationService valtimoAuthorizationService(@NotNull List<? extends AuthorizationSpecificationFactory<?>> authorizationSpecificationFactories, @NotNull List<? extends AuthorizationEntityMapper<?, ?>> mappers, @NotNull List<? extends ResourceActionProvider<?>> actionProviders, @NotNull PermissionRepository permissionRepository, @NotNull RoleRepository roleRepository, @NotNull UserManagementService userManagementService) {
        Intrinsics.checkNotNullParameter(authorizationSpecificationFactories, (String)"authorizationSpecificationFactories");
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        Intrinsics.checkNotNullParameter(actionProviders, (String)"actionProviders");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        Intrinsics.checkNotNullParameter((Object)roleRepository, (String)"roleRepository");
        Intrinsics.checkNotNullParameter((Object)userManagementService, (String)"userManagementService");
        ValtimoAuthorizationService authorizationService = new ValtimoAuthorizationService(authorizationSpecificationFactories, mappers, actionProviders, permissionRepository, userManagementService);
        new AuthorizationServiceHolder(authorizationService);
        return authorizationService;
    }

    @Order(value=-2147483647)
    @Bean
    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnMissingBean(name={"authorizationLiquibaseMasterChangeLogLocation"})
    @NotNull
    public LiquibaseMasterChangeLogLocation authorizationLiquibaseMasterChangeLogLocation() {
        return new LiquibaseMasterChangeLogLocation("config/liquibase/authorization-master.xml");
    }

    @Bean
    @NotNull
    public Module permissionConditionTypeModule() {
        return (Module)new PermissionConditionTypeModule();
    }

    @Bean
    @Order(value=-2147483648)
    @NotNull
    public <T> AuthorizationSpecificationFactory<T> noopAuthorizationSpecificationFactory() {
        return new NoopAuthorizationSpecificationFactory();
    }

    @Bean
    @Order(value=-2147483647)
    @NotNull
    public <T> AuthorizationSpecificationFactory<T> denyAuthorizationSpecificationFactory() {
        return new DenyAuthorizationSpecificationFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={RoleDeployer.class})
    @Order(value=1)
    @NotNull
    public RoleDeployer roleDeployer(@NotNull ObjectMapper objectMapper, @NotNull RoleRepository roleRepository, @NotNull ChangelogService changelogService, @Value(value="${valtimo.changelog.pbac.clear-tables:false}") boolean clearTables) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)roleRepository, (String)"roleRepository");
        Intrinsics.checkNotNullParameter((Object)changelogService, (String)"changelogService");
        return new RoleDeployer(objectMapper, roleRepository, changelogService, clearTables);
    }

    @Bean
    @ConditionalOnMissingBean(value={PermissionDeployer.class})
    @Order(value=2)
    @NotNull
    public PermissionDeployer permissionDeployer(@NotNull ObjectMapper objectMapper, @NotNull PermissionRepository permissionRepository, @NotNull RoleRepository roleRepository, @NotNull ChangelogService changelogService, @Value(value="${valtimo.changelog.pbac.clear-tables:false}") boolean clearTables) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        Intrinsics.checkNotNullParameter((Object)roleRepository, (String)"roleRepository");
        Intrinsics.checkNotNullParameter((Object)changelogService, (String)"changelogService");
        return new PermissionDeployer(objectMapper, permissionRepository, roleRepository, changelogService, clearTables);
    }

    @Bean
    @ConditionalOnMissingBean(value={RoleManagementResource.class})
    @NotNull
    public RoleManagementResource roleManagementResource(@NotNull RoleRepository roleRepository, @NotNull PermissionRepository permissionRepository) {
        Intrinsics.checkNotNullParameter((Object)roleRepository, (String)"roleRepository");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        return new RoleManagementResource(roleRepository, permissionRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={PermissionResource.class})
    @NotNull
    public PermissionResource permissionResource(@NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        return new PermissionResource(authorizationService);
    }

    @Bean
    @NotNull
    public AuthorizationSupportedHelper authorizationSupportedHelper() {
        return AuthorizationSupportedHelper.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean(value={PermissionManagementResource.class})
    @NotNull
    public PermissionManagementResource permissionManagementResource(@NotNull PermissionRepository permissionRepository) {
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        return new PermissionManagementResource(permissionRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={RunWithoutAuthorizationAspect.class})
    @NotNull
    public RunWithoutAuthorizationAspect runWithoutAuthorizationAspect() {
        return new RunWithoutAuthorizationAspect();
    }
}

