/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization.deployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ritense.authorization.AuthorizationSupportedHelper;
import com.ritense.authorization.deployment.PermissionChangeset;
import com.ritense.authorization.deployment.PermissionDto;
import com.ritense.authorization.permission.PermissionRepository;
import com.ritense.authorization.role.RoleRepository;
import com.ritense.valtimo.changelog.domain.ChangesetDeployer;
import com.ritense.valtimo.changelog.domain.ChangesetDetails;
import com.ritense.valtimo.changelog.service.ChangelogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ritense/authorization/deployment/PermissionDeployer;", "Lcom/ritense/valtimo/changelog/domain/ChangesetDeployer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "permissionRepository", "Lcom/ritense/authorization/permission/PermissionRepository;", "roleRepository", "Lcom/ritense/authorization/role/RoleRepository;", "changelogService", "Lcom/ritense/valtimo/changelog/service/ChangelogService;", "clearTables", "", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/ritense/authorization/permission/PermissionRepository;Lcom/ritense/authorization/role/RoleRepository;Lcom/ritense/valtimo/changelog/service/ChangelogService;Z)V", "before", "", "deploy", "permissions", "", "Lcom/ritense/authorization/deployment/PermissionDto;", "getChangelogDetails", "Lcom/ritense/valtimo/changelog/domain/ChangesetDetails;", "filename", "", "content", "getPath", "Companion", "authorization"})
@SourceDebugExtension(value={"SMAP\nPermissionDeployer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionDeployer.kt\ncom/ritense/authorization/deployment/PermissionDeployer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n50#2:70\n43#2:71\n1549#3:72\n1620#3,3:73\n*S KotlinDebug\n*F\n+ 1 PermissionDeployer.kt\ncom/ritense/authorization/deployment/PermissionDeployer\n*L\n46#1:70\n46#1:71\n58#1:72\n58#1:73,3\n*E\n"})
public final class PermissionDeployer
implements ChangesetDeployer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final PermissionRepository permissionRepository;
    @NotNull
    private final RoleRepository roleRepository;
    @NotNull
    private final ChangelogService changelogService;
    private final boolean clearTables;
    @NotNull
    public static final String KEY = "permission";

    public PermissionDeployer(@NotNull ObjectMapper objectMapper, @NotNull PermissionRepository permissionRepository, @NotNull RoleRepository roleRepository, @NotNull ChangelogService changelogService, boolean clearTables) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        Intrinsics.checkNotNullParameter((Object)roleRepository, (String)"roleRepository");
        Intrinsics.checkNotNullParameter((Object)changelogService, (String)"changelogService");
        this.objectMapper = objectMapper;
        this.permissionRepository = permissionRepository;
        this.roleRepository = roleRepository;
        this.changelogService = changelogService;
        this.clearTables = clearTables;
    }

    @NotNull
    public String getPath() {
        return "classpath*:**/*.permission.json";
    }

    public void before() {
        if (this.clearTables) {
            this.permissionRepository.deleteAll();
            this.changelogService.deleteChangesetsByKey(KEY);
        }
    }

    @NotNull
    public List<ChangesetDetails> getChangelogDetails(@NotNull String filename, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ObjectMapper $this$readValue$iv = this.objectMapper;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        PermissionChangeset changeset = (PermissionChangeset)$this$readValue$iv.readValue(content, (TypeReference)new TypeReference<PermissionChangeset>(){});
        return CollectionsKt.listOf((Object)new ChangesetDetails(changeset.getChangesetId(), changeset.getPermissions(), KEY, (Function0)new Function0<Unit>(this, changeset){
            final /* synthetic */ PermissionDeployer this$0;
            final /* synthetic */ PermissionChangeset $changeset;
            {
                this.this$0 = $receiver;
                this.$changeset = $changeset;
                super(0);
            }

            public final void invoke() {
                this.this$0.deploy(this.$changeset.getPermissions());
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void deploy(@NotNull List<PermissionDto> permissions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Iterable $this$map$iv = permissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionDto permissionDto = (PermissionDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AuthorizationSupportedHelper.INSTANCE.checkSupported(it.getResourceType());
            collection.add(it.toPermission(this.roleRepository));
        }
        List permissionsToSave = (List)destination$iv$iv;
        this.permissionRepository.saveAll(permissionsToSave);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ritense/authorization/deployment/PermissionDeployer$Companion;", "", "()V", "KEY", "", "authorization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

