/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization.deployment;

import com.fasterxml.jackson.annotation.JsonView;
import com.ritense.authorization.Action;
import com.ritense.authorization.permission.ConditionContainer;
import com.ritense.authorization.permission.Permission;
import com.ritense.authorization.permission.PermissionView;
import com.ritense.authorization.permission.condition.PermissionCondition;
import com.ritense.authorization.role.Role;
import com.ritense.authorization.role.RoleRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006!"}, d2={"Lcom/ritense/authorization/deployment/PermissionDto;", "", "resourceType", "Ljava/lang/Class;", "action", "", "conditions", "", "Lcom/ritense/authorization/permission/condition/PermissionCondition;", "roleKey", "(Ljava/lang/Class;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getConditions", "()Ljava/util/List;", "getResourceType", "()Ljava/lang/Class;", "getRoleKey", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toPermission", "Lcom/ritense/authorization/permission/Permission;", "roleRepository", "Lcom/ritense/authorization/role/RoleRepository;", "toString", "authorization"})
public final class PermissionDto {
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @NotNull
    private final Class<?> resourceType;
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @NotNull
    private final String action;
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @NotNull
    private final List<PermissionCondition> conditions;
    @JsonView(value={PermissionView.PermissionManagement.class})
    @NotNull
    private final String roleKey;

    public PermissionDto(@NotNull Class<?> resourceType, @NotNull String action, @NotNull List<? extends PermissionCondition> conditions, @NotNull String roleKey) {
        Intrinsics.checkNotNullParameter(resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)roleKey, (String)"roleKey");
        this.resourceType = resourceType;
        this.action = action;
        this.conditions = conditions;
        this.roleKey = roleKey;
    }

    public /* synthetic */ PermissionDto(Class clazz, String string, List list, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(clazz, string, list, string2);
    }

    @NotNull
    public final Class<?> getResourceType() {
        return this.resourceType;
    }

    @NotNull
    public final String getAction() {
        return this.action;
    }

    @NotNull
    public final List<PermissionCondition> getConditions() {
        return this.conditions;
    }

    @NotNull
    public final String getRoleKey() {
        return this.roleKey;
    }

    @NotNull
    public final Permission toPermission(@NotNull RoleRepository roleRepository) {
        Intrinsics.checkNotNullParameter((Object)roleRepository, (String)"roleRepository");
        Action action = new Action(this.action);
        ConditionContainer conditionContainer = new ConditionContainer(this.conditions);
        Role role = roleRepository.findByKey(this.roleKey);
        Intrinsics.checkNotNull((Object)role);
        return new Permission(null, this.resourceType, action, conditionContainer, role, 1, null);
    }

    @NotNull
    public final Class<?> component1() {
        return this.resourceType;
    }

    @NotNull
    public final String component2() {
        return this.action;
    }

    @NotNull
    public final List<PermissionCondition> component3() {
        return this.conditions;
    }

    @NotNull
    public final String component4() {
        return this.roleKey;
    }

    @NotNull
    public final PermissionDto copy(@NotNull Class<?> resourceType, @NotNull String action, @NotNull List<? extends PermissionCondition> conditions, @NotNull String roleKey) {
        Intrinsics.checkNotNullParameter(resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)roleKey, (String)"roleKey");
        return new PermissionDto(resourceType, action, conditions, roleKey);
    }

    public static /* synthetic */ PermissionDto copy$default(PermissionDto permissionDto, Class clazz, String string, List list, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            clazz = permissionDto.resourceType;
        }
        if ((n & 2) != 0) {
            string = permissionDto.action;
        }
        if ((n & 4) != 0) {
            list = permissionDto.conditions;
        }
        if ((n & 8) != 0) {
            string2 = permissionDto.roleKey;
        }
        return permissionDto.copy(clazz, string, list, string2);
    }

    @NotNull
    public String toString() {
        return "PermissionDto(resourceType=" + this.resourceType + ", action=" + this.action + ", conditions=" + this.conditions + ", roleKey=" + this.roleKey + ")";
    }

    public int hashCode() {
        int result = this.resourceType.hashCode();
        result = result * 31 + this.action.hashCode();
        result = result * 31 + ((Object)this.conditions).hashCode();
        result = result * 31 + this.roleKey.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PermissionDto)) {
            return false;
        }
        PermissionDto permissionDto = (PermissionDto)other;
        if (!Intrinsics.areEqual(this.resourceType, permissionDto.resourceType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.action, (Object)permissionDto.action)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.conditions, permissionDto.conditions)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.roleKey, (Object)permissionDto.roleKey);
    }
}

