/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization.permission.condition;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.ritense.authorization.jackson.ComparableDeserializer;
import com.ritense.authorization.permission.PermissionView;
import com.ritense.authorization.permission.condition.PermissionConditionOperator;
import com.ritense.authorization.permission.condition.PermissionConditionType;
import com.ritense.authorization.permission.condition.PermissionConditionValueResolver;
import com.ritense.authorization.permission.condition.ReflectingPermissionCondition;
import com.ritense.valtimo.contract.database.QueryDialectHelper;
import com.ritense.valtimo.contract.json.MapperSingleton;
import java.util.Collection;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="expression")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 7*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u00017B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0001\u0010\t\u001a\u0004\u0018\u00018\u0000\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u00c6\u0003JN\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0003\u0010\t\u001a\u0004\u0018\u00018\u00002\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\u0012\u0010\"\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010!H\u0002J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u001f\u0010&\u001a\u00020\u001f\"\b\b\u0001\u0010'*\u00020!2\u0006\u0010(\u001a\u0002H'H\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u0004\u0018\u00010\u00052\u0006\u0010(\u001a\u00020!H\u0002JJ\u0010+\u001a\u00020,\"\b\b\u0001\u0010'*\u00020!2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H'0.2\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H'0\u000b2\u0006\u00104\u001a\u000205H\u0016J\t\u00106\u001a\u00020\u0005H\u00d6\u0001R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u001a\u0010\t\u001a\u0004\u0018\u00018\u00008\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00068"}, d2={"Lcom/ritense/authorization/permission/condition/ExpressionPermissionCondition;", "V", "", "Lcom/ritense/authorization/permission/condition/ReflectingPermissionCondition;", "field", "", "path", "operator", "Lcom/ritense/authorization/permission/condition/PermissionConditionOperator;", "value", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Lcom/ritense/authorization/permission/condition/PermissionConditionOperator;Ljava/lang/Comparable;Ljava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "getField", "()Ljava/lang/String;", "getOperator", "()Lcom/ritense/authorization/permission/condition/PermissionConditionOperator;", "getPath", "getValue", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/String;Lcom/ritense/authorization/permission/condition/PermissionConditionOperator;Ljava/lang/Comparable;Ljava/lang/Class;)Lcom/ritense/authorization/permission/condition/ExpressionPermissionCondition;", "equals", "", "other", "", "evaluateExpression", "pathValue", "hashCode", "", "isValid", "E", "entity", "(Ljava/lang/Object;)Z", "toJsonString", "toPredicate", "Ljavax/persistence/criteria/Predicate;", "root", "Ljavax/persistence/criteria/Root;", "query", "Ljavax/persistence/criteria/AbstractQuery;", "criteriaBuilder", "Ljavax/persistence/criteria/CriteriaBuilder;", "resourceType", "queryDialectHelper", "Lcom/ritense/valtimo/contract/database/QueryDialectHelper;", "toString", "Companion", "authorization"})
public final class ExpressionPermissionCondition<V extends Comparable<? super V>>
extends ReflectingPermissionCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @NotNull
    private final String field;
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @NotNull
    private final String path;
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @NotNull
    private final PermissionConditionOperator operator;
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @Nullable
    private final V value;
    @JsonView(value={PermissionView.RoleManagement.class, PermissionView.PermissionManagement.class})
    @NotNull
    private final Class<V> clazz;
    @NotNull
    public static final String EXPRESSION = "expression";

    public ExpressionPermissionCondition(@NotNull String field, @NotNull String path, @NotNull PermissionConditionOperator operator, @JsonDeserialize(using=ComparableDeserializer.class) @Nullable V value, @NotNull Class<V> clazz) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        super(PermissionConditionType.EXPRESSION);
        this.field = field;
        this.path = path;
        this.operator = operator;
        this.value = value;
        this.clazz = clazz;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final PermissionConditionOperator getOperator() {
        return this.operator;
    }

    @Nullable
    public final V getValue() {
        return this.value;
    }

    @NotNull
    public final Class<V> getClazz() {
        return this.clazz;
    }

    public <E> boolean isValid(@NotNull E entity) {
        Object object;
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        String string = this.toJsonString(entity);
        if (string == null) {
            return this.value == null;
        }
        String jsonValue = string;
        try {
            object = JsonPath.read((String)jsonValue, (String)this.path, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            object = null;
        }
        Object pathValue = object;
        if (pathValue != null && !(pathValue instanceof Collection) && !Intrinsics.areEqual(pathValue.getClass(), this.clazz)) {
            return false;
        }
        return this.evaluateExpression(pathValue);
    }

    @NotNull
    public <E> javax.persistence.criteria.Predicate toPredicate(@NotNull Root<E> root, @NotNull AbstractQuery<?> query, @NotNull CriteriaBuilder criteriaBuilder, @NotNull Class<E> resourceType, @NotNull QueryDialectHelper queryDialectHelper) {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)criteriaBuilder, (String)"criteriaBuilder");
        Intrinsics.checkNotNullParameter(resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter((Object)queryDialectHelper, (String)"queryDialectHelper");
        Path<Object> path = this.createDatabaseObjectPath(this.field, root);
        Object resolvedValue = PermissionConditionValueResolver.INSTANCE.resolveValue(this.value);
        if (this.operator == PermissionConditionOperator.LIST_CONTAINS) {
            if (Collection.class.isAssignableFrom(this.clazz)) {
                javax.persistence.criteria.Predicate predicate = queryDialectHelper.getJsonArrayContainsExpression(criteriaBuilder, path, this.path, String.valueOf(resolvedValue));
                Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"queryDialectHelper.getJs\u2026tring()\n                )");
                return predicate;
            }
            throw new IllegalStateException("PBAC: Unsupported 'contains' for clazz '" + this.clazz + "'");
        }
        Expression expression = queryDialectHelper.getJsonValueExpression(criteriaBuilder, path, this.path, this.clazz);
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"queryDialectHelper.getJs\u2026, path, this.path, clazz)");
        return this.operator.toPredicate(criteriaBuilder, expression, resolvedValue);
    }

    private final String toJsonString(Object entity) {
        String string;
        Object object = this.findEntityFieldValue(entity, this.field);
        if (object == null) {
            return null;
        }
        Object fieldValue = object;
        if (fieldValue instanceof String) {
            string = (String)fieldValue;
        } else {
            String string2;
            try {
                String string3 = MapperSingleton.INSTANCE.get().writeValueAsString(fieldValue);
                if (string3 == null) {
                    return null;
                }
                string2 = string3;
            }
            catch (Exception e) {
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    private final boolean evaluateExpression(Object pathValue) {
        return this.operator.evaluate(pathValue, PermissionConditionValueResolver.INSTANCE.resolveValue(this.value));
    }

    @NotNull
    public final String component1() {
        return this.field;
    }

    @NotNull
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final PermissionConditionOperator component3() {
        return this.operator;
    }

    @Nullable
    public final V component4() {
        return this.value;
    }

    @NotNull
    public final Class<V> component5() {
        return this.clazz;
    }

    @NotNull
    public final ExpressionPermissionCondition<V> copy(@NotNull String field, @NotNull String path, @NotNull PermissionConditionOperator operator, @JsonDeserialize(using=ComparableDeserializer.class) @Nullable V value, @NotNull Class<V> clazz) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return new ExpressionPermissionCondition<V>(field, path, operator, value, clazz);
    }

    public static /* synthetic */ ExpressionPermissionCondition copy$default(ExpressionPermissionCondition expressionPermissionCondition, String string, String string2, PermissionConditionOperator permissionConditionOperator, Comparable comparable, Class clazz, int n, Object object) {
        if ((n & 1) != 0) {
            string = expressionPermissionCondition.field;
        }
        if ((n & 2) != 0) {
            string2 = expressionPermissionCondition.path;
        }
        if ((n & 4) != 0) {
            permissionConditionOperator = expressionPermissionCondition.operator;
        }
        if ((n & 8) != 0) {
            comparable = expressionPermissionCondition.value;
        }
        if ((n & 0x10) != 0) {
            clazz = expressionPermissionCondition.clazz;
        }
        return expressionPermissionCondition.copy(string, string2, permissionConditionOperator, comparable, clazz);
    }

    @NotNull
    public String toString() {
        return "ExpressionPermissionCondition(field=" + this.field + ", path=" + this.path + ", operator=" + this.operator + ", value=" + this.value + ", clazz=" + this.clazz + ")";
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + this.operator.hashCode();
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + this.clazz.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExpressionPermissionCondition)) {
            return false;
        }
        ExpressionPermissionCondition expressionPermissionCondition = (ExpressionPermissionCondition)other;
        if (!Intrinsics.areEqual((Object)this.field, (Object)expressionPermissionCondition.field)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)expressionPermissionCondition.path)) {
            return false;
        }
        if (this.operator != expressionPermissionCondition.operator) {
            return false;
        }
        if (!Intrinsics.areEqual(this.value, expressionPermissionCondition.value)) {
            return false;
        }
        return Intrinsics.areEqual(this.clazz, expressionPermissionCondition.clazz);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ritense/authorization/permission/condition/ExpressionPermissionCondition$Companion;", "", "()V", "EXPRESSION", "", "authorization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

