/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization.specification;

import com.ritense.authorization.Action;
import com.ritense.authorization.AuthorizationServiceHolder;
import com.ritense.authorization.permission.ConditionContainer;
import com.ritense.authorization.permission.Permission;
import com.ritense.authorization.permission.condition.ContainerPermissionCondition;
import com.ritense.authorization.permission.condition.PermissionCondition;
import com.ritense.authorization.request.AuthorizationRequest;
import com.ritense.authorization.request.EntityAuthorizationRequest;
import com.ritense.authorization.request.RelatedEntityAuthorizationRequest;
import com.ritense.authorization.role.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.domain.Specification;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007J4\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000\"\b\b\u0001\u0010\u0014*\u00020\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0002J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH$\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b\u001eJ\u0016\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0002J\u0016\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0002J\u001e\u0010$\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010%\u001a\u00020&H\u0002J*\u0010'\u001a\u00020\u000f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010\u0010\u001a\u00020\u0011H&J*\u0010'\u001a\u00020\u000f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006-"}, d2={"Lcom/ritense/authorization/specification/AuthorizationSpecification;", "T", "", "Lorg/springframework/data/jpa/domain/Specification;", "authRequest", "Lcom/ritense/authorization/request/AuthorizationRequest;", "permissions", "", "Lcom/ritense/authorization/permission/Permission;", "(Lcom/ritense/authorization/request/AuthorizationRequest;Ljava/util/List;)V", "getAuthRequest", "()Lcom/ritense/authorization/request/AuthorizationRequest;", "getPermissions", "()Ljava/util/List;", "combinePredicates", "Ljavax/persistence/criteria/Predicate;", "criteriaBuilder", "Ljavax/persistence/criteria/CriteriaBuilder;", "predicates", "findSpecification", "TO", "Lcom/ritense/authorization/request/RelatedEntityAuthorizationRequest;", "container", "Lcom/ritense/authorization/permission/condition/ContainerPermissionCondition;", "identifierToEntity", "identifier", "", "(Ljava/lang/String;)Ljava/lang/Object;", "isAuthorized", "", "isAuthorized$authorization", "isAuthorizedForEntity", "entityAuthorizationRequest", "Lcom/ritense/authorization/request/EntityAuthorizationRequest;", "isAuthorizedForRelatedEntity", "relatedEntityAuthorizationRequest", "isAuthorizedForRelatedEntityRecursive", "permissionCondition", "Lcom/ritense/authorization/permission/condition/PermissionCondition;", "toPredicate", "root", "Ljavax/persistence/criteria/Root;", "query", "Ljavax/persistence/criteria/AbstractQuery;", "Ljavax/persistence/criteria/CriteriaQuery;", "authorization"})
@SourceDebugExtension(value={"SMAP\nAuthorizationSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationSpecification.kt\ncom/ritense/authorization/specification/AuthorizationSpecification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,167:1\n766#2:168\n857#2,2:169\n1726#2,2:171\n1747#2,3:173\n1728#2:176\n766#2:177\n857#2,2:178\n288#2:180\n1726#2,3:181\n289#2:184\n1726#2,3:185\n37#3,2:188\n*S KotlinDebug\n*F\n+ 1 AuthorizationSpecification.kt\ncom/ritense/authorization/specification/AuthorizationSpecification\n*L\n52#1:168\n52#1:169,2\n55#1:171,2\n56#1:173,3\n55#1:176\n76#1:177\n76#1:178,2\n80#1:180\n81#1:181,3\n80#1:184\n98#1:185,3\n108#1:188,2\n*E\n"})
public abstract class AuthorizationSpecification<T>
implements Specification<T> {
    @NotNull
    private final AuthorizationRequest<T> authRequest;
    @NotNull
    private final List<Permission> permissions;

    public AuthorizationSpecification(@NotNull AuthorizationRequest<T> authRequest, @NotNull List<Permission> permissions) {
        Intrinsics.checkNotNullParameter(authRequest, (String)"authRequest");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.authRequest = authRequest;
        this.permissions = permissions;
    }

    @NotNull
    protected final AuthorizationRequest<T> getAuthRequest() {
        return this.authRequest;
    }

    @NotNull
    protected final List<Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isAuthorized$authorization() {
        AuthorizationRequest<T> authorizationRequest = this.authRequest;
        return authorizationRequest instanceof EntityAuthorizationRequest ? this.isAuthorizedForEntity((EntityAuthorizationRequest)this.authRequest) : (authorizationRequest instanceof RelatedEntityAuthorizationRequest ? this.isAuthorizedForRelatedEntity((RelatedEntityAuthorizationRequest)this.authRequest) : false);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAuthorizedForEntity(EntityAuthorizationRequest<T> entityAuthorizationRequest) {
        boolean bl;
        block9: {
            void $this$filterTo$iv$iv;
            if (entityAuthorizationRequest.getEntities().isEmpty()) {
                return false;
            }
            Iterable $this$filter$iv = this.permissions;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Permission permission = (Permission)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual(entityAuthorizationRequest.getResourceType(), permission.getResourceType()) && Intrinsics.areEqual(entityAuthorizationRequest.getAction(), permission.getAction()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List permissions = (List)destination$iv$iv;
            Iterable $this$all$iv = entityAuthorizationRequest.getEntities();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                object = $this$all$iv.iterator();
                while (object.hasNext()) {
                    boolean bl3;
                    block8: {
                        Object element$iv;
                        Object entity = element$iv = object.next();
                        boolean bl4 = false;
                        Iterable $this$any$iv = permissions;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                Permission permission = (Permission)element$iv2;
                                boolean bl5 = false;
                                if (!permission.appliesTo(entityAuthorizationRequest.getResourceType(), entity)) continue;
                                bl3 = true;
                                break block8;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAuthorizedForRelatedEntity(RelatedEntityAuthorizationRequest<T> relatedEntityAuthorizationRequest) {
        Object v2;
        block7: {
            void $this$filterTo$iv$iv;
            if (Intrinsics.areEqual(relatedEntityAuthorizationRequest.getResourceType(), relatedEntityAuthorizationRequest.getRelatedResourceType())) {
                Object[] objectArray = new Object[]{this.identifierToEntity(relatedEntityAuthorizationRequest.getRelatedResourceId())};
                return this.isAuthorizedForEntity(new EntityAuthorizationRequest<Object>(relatedEntityAuthorizationRequest.getResourceType(), relatedEntityAuthorizationRequest.getAction(), objectArray));
            }
            Iterable $this$filter$iv = this.permissions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Permission permission = (Permission)element$iv$iv;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual(relatedEntityAuthorizationRequest.getResourceType(), permission.getResourceType()) && Intrinsics.areEqual(relatedEntityAuthorizationRequest.getAction(), permission.getAction());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block6: {
                    Permission permission = (Permission)element$iv;
                    boolean bl3 = false;
                    Iterable $this$all$iv = permission.getConditionContainer().getConditions();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            PermissionCondition permissionCondition = (PermissionCondition)element$iv2;
                            boolean bl4 = false;
                            if (this.isAuthorizedForRelatedEntityRecursive(relatedEntityAuthorizationRequest, permissionCondition)) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        return v2 != null;
    }

    private final boolean isAuthorizedForRelatedEntityRecursive(RelatedEntityAuthorizationRequest<T> relatedEntityAuthorizationRequest, PermissionCondition permissionCondition) {
        boolean bl;
        block7: {
            if (permissionCondition instanceof ContainerPermissionCondition) {
                if (Intrinsics.areEqual(((ContainerPermissionCondition)permissionCondition).getResourceType(), relatedEntityAuthorizationRequest.getRelatedResourceType())) {
                    bl = this.findSpecification(relatedEntityAuthorizationRequest, (ContainerPermissionCondition)permissionCondition).isAuthorized$authorization();
                } else {
                    Iterable $this$all$iv = ((ContainerPermissionCondition)permissionCondition).getConditions();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PermissionCondition it = (PermissionCondition)element$iv;
                            boolean bl2 = false;
                            if (this.isAuthorizedForRelatedEntityRecursive(relatedEntityAuthorizationRequest, it)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final Predicate combinePredicates(@NotNull CriteriaBuilder criteriaBuilder, @NotNull List<? extends Predicate> predicates) {
        Intrinsics.checkNotNullParameter((Object)criteriaBuilder, (String)"criteriaBuilder");
        Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
        Collection $this$toTypedArray$iv = predicates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Predicate[] predicateArray = thisCollection$iv.toArray(new Predicate[0]);
        Predicate predicate = criteriaBuilder.or(Arrays.copyOf(predicateArray, predicateArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"criteriaBuilder.or(*predicates.toTypedArray())");
        return predicate;
    }

    private final <TO> AuthorizationSpecification<TO> findSpecification(RelatedEntityAuthorizationRequest<T> authRequest, ContainerPermissionCondition<TO> container) {
        return AuthorizationServiceHolder.Companion.getCurrentInstance().getAuthorizationSpecification(new RelatedEntityAuthorizationRequest<TO>(container.getResourceType(), new Action("ignore"), authRequest.getRelatedResourceType(), authRequest.getRelatedResourceId()), CollectionsKt.listOf((Object)new Permission(null, container.getResourceType(), new Action("ignore"), new ConditionContainer(container.getConditions()), new Role(null, "", 1, null), 1, null)));
    }

    @NotNull
    protected abstract T identifierToEntity(@NotNull String var1);

    @NotNull
    public Predicate toPredicate(@NotNull Root<T> root, @NotNull CriteriaQuery<?> query, @NotNull CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)criteriaBuilder, (String)"criteriaBuilder");
        return this.toPredicate(root, (AbstractQuery)query, criteriaBuilder);
    }

    @NotNull
    public abstract Predicate toPredicate(@NotNull Root<T> var1, @NotNull AbstractQuery<?> var2, @NotNull CriteriaBuilder var3);
}

