/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization.web;

import com.ritense.authorization.Action;
import com.ritense.authorization.AuthorizationService;
import com.ritense.authorization.ResourceNotSupportedException;
import com.ritense.authorization.request.RelatedEntityAuthorizationRequest;
import com.ritense.authorization.web.request.PermissionAvailableRequest;
import com.ritense.authorization.web.result.PermissionAvailableResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/json;charset=UTF-8"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ritense/authorization/web/PermissionResource;", "", "authorizationService", "Lcom/ritense/authorization/AuthorizationService;", "(Lcom/ritense/authorization/AuthorizationService;)V", "userHasPermission", "Lorg/springframework/http/ResponseEntity;", "", "Lcom/ritense/authorization/web/result/PermissionAvailableResult;", "permissionsPresentRequest", "Lcom/ritense/authorization/web/request/PermissionAvailableRequest;", "authorization"})
@SourceDebugExtension(value={"SMAP\nPermissionResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionResource.kt\ncom/ritense/authorization/web/PermissionResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n*S KotlinDebug\n*F\n+ 1 PermissionResource.kt\ncom/ritense/authorization/web/PermissionResource\n*L\n48#1:73\n48#1:74,3\n*E\n"})
public class PermissionResource {
    @NotNull
    private AuthorizationService authorizationService;

    public PermissionResource(@NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.authorizationService = authorizationService;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PostMapping(value={"/v1/permissions"})
    @NotNull
    public ResponseEntity<List<PermissionAvailableResult>> userHasPermission(@RequestBody @NotNull List<PermissionAvailableRequest> permissionsPresentRequest) {
        Intrinsics.checkNotNullParameter(permissionsPresentRequest, (String)"permissionsPresentRequest");
        List permissionResponse = null;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = permissionsPresentRequest;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PermissionAvailableRequest permissionAvailableRequest = (PermissionAvailableRequest)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PermissionAvailableResult(it.getResource(), it.getAction(), it.getContext(), this.authorizationService.hasPermission(new RelatedEntityAuthorizationRequest(it.getResourceAsClass(), new Action(it.getAction()), it.getContext().getResourceAsClass(), it.getContext().getIdentifier()))));
            }
            permissionResponse = (List)destination$iv$iv;
        }
        catch (ClassNotFoundException ex) {
            throw new AccessDeniedException("Unauthorized", (Throwable)ex);
        }
        catch (ResourceNotSupportedException ex) {
            throw new AccessDeniedException("Unauthorized", (Throwable)ex);
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)permissionResponse);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(permissionResponse)");
        return responseEntity;
    }
}

