/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.authorization.web;

import com.fasterxml.jackson.annotation.JsonView;
import com.ritense.authorization.AuthorizationSupportedHelper;
import com.ritense.authorization.deployment.PermissionDto;
import com.ritense.authorization.permission.Permission;
import com.ritense.authorization.permission.PermissionRepository;
import com.ritense.authorization.permission.PermissionView;
import com.ritense.authorization.role.Role;
import com.ritense.authorization.role.RoleRepository;
import com.ritense.authorization.web.request.DeleteRolesRequest;
import com.ritense.authorization.web.request.SaveRoleRequest;
import com.ritense.authorization.web.request.UpdateRolePermissionRequest;
import com.ritense.authorization.web.request.UpdateRoleRequest;
import com.ritense.authorization.web.result.RoleResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/management"}, produces={"application/json;charset=UTF-8"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u001e\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\f2\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0017J\u0014\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\fH\u0017J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0001\u0010\u001b\u001a\u00020\u00182\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J.\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\f2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u000e\b\u0001\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0015H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lcom/ritense/authorization/web/RoleManagementResource;", "", "roleRepository", "Lcom/ritense/authorization/role/RoleRepository;", "permissionRepository", "Lcom/ritense/authorization/permission/PermissionRepository;", "(Lcom/ritense/authorization/role/RoleRepository;Lcom/ritense/authorization/permission/PermissionRepository;)V", "getPermissionRepository", "()Lcom/ritense/authorization/permission/PermissionRepository;", "getRoleRepository", "()Lcom/ritense/authorization/role/RoleRepository;", "createRole", "Lorg/springframework/http/ResponseEntity;", "Lcom/ritense/authorization/web/result/RoleResult;", "saveRoleRequest", "Lcom/ritense/authorization/web/request/SaveRoleRequest;", "deleteRole", "Ljava/lang/Void;", "deleteRolesRequest", "Lcom/ritense/authorization/web/request/DeleteRolesRequest;", "getRolePermissions", "", "Lcom/ritense/authorization/deployment/PermissionDto;", "roleKey", "", "getRoles", "updateRole", "oldRoleKey", "updateRoleRequest", "Lcom/ritense/authorization/web/request/UpdateRoleRequest;", "updateRolePermissions", "rolePermissions", "Lcom/ritense/authorization/web/request/UpdateRolePermissionRequest;", "authorization"})
@SourceDebugExtension(value={"SMAP\nRoleManagementResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoleManagementResource.kt\ncom/ritense/authorization/web/RoleManagementResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1549#2:116\n1620#2,3:117\n1549#2:120\n1620#2,3:121\n1549#2:124\n1620#2,3:125\n1549#2:128\n1620#2,3:129\n*S KotlinDebug\n*F\n+ 1 RoleManagementResource.kt\ncom/ritense/authorization/web/RoleManagementResource\n*L\n53#1:116\n53#1:117,3\n92#1:120\n92#1:121,3\n108#1:124\n108#1:125,3\n112#1:128\n112#1:129,3\n*E\n"})
public class RoleManagementResource {
    @NotNull
    private final RoleRepository roleRepository;
    @NotNull
    private final PermissionRepository permissionRepository;

    public RoleManagementResource(@NotNull RoleRepository roleRepository, @NotNull PermissionRepository permissionRepository) {
        Intrinsics.checkNotNullParameter((Object)roleRepository, (String)"roleRepository");
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        this.roleRepository = roleRepository;
        this.permissionRepository = permissionRepository;
    }

    @NotNull
    public RoleRepository getRoleRepository() {
        return this.roleRepository;
    }

    @NotNull
    public PermissionRepository getPermissionRepository() {
        return this.permissionRepository;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/v1/roles"})
    @NotNull
    public ResponseEntity<List<RoleResult>> getRoles() {
        void $this$mapTo$iv$iv;
        List list = this.getRoleRepository().findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"roleRepository.findAll()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(RoleResult.Companion.fromRole((Role)it));
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(roleRepository.findAl\u2026oleResult.fromRole(it) })");
        return responseEntity;
    }

    @PostMapping(value={"/v1/roles"})
    @NotNull
    public ResponseEntity<RoleResult> createRole(@RequestBody @NotNull SaveRoleRequest saveRoleRequest) {
        Intrinsics.checkNotNullParameter((Object)saveRoleRequest, (String)"saveRoleRequest");
        try {
            Object object = this.getRoleRepository().save(saveRoleRequest.toRole());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"roleRepository.save(saveRoleRequest.toRole())");
            Role role = (Role)object;
            ResponseEntity responseEntity = ResponseEntity.ok((Object)RoleResult.Companion.fromRole(role));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(RoleResult.fromRole(role))");
            return responseEntity;
        }
        catch (Exception ex) {
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(HttpStatus.CONFLICT).build()");
            return responseEntity;
        }
    }

    @PutMapping(value={"/v1/roles/{oldRoleKey}"})
    @NotNull
    public ResponseEntity<RoleResult> updateRole(@PathVariable @NotNull String oldRoleKey, @RequestBody @NotNull UpdateRoleRequest updateRoleRequest) {
        Intrinsics.checkNotNullParameter((Object)oldRoleKey, (String)"oldRoleKey");
        Intrinsics.checkNotNullParameter((Object)updateRoleRequest, (String)"updateRoleRequest");
        Role oldRole = this.getRoleRepository().findByKey(oldRoleKey);
        RoleRepository roleRepository = this.getRoleRepository();
        Role role = oldRole;
        Intrinsics.checkNotNull((Object)role);
        Object object = roleRepository.save(updateRoleRequest.toRole(role.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"roleRepository.save(upda\u2026est.toRole(oldRole!!.id))");
        Role role2 = (Role)object;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)RoleResult.Companion.fromRole(role2));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(RoleResult.fromRole(role))");
        return responseEntity;
    }

    @DeleteMapping(value={"/v1/roles"})
    @Transactional
    @NotNull
    public ResponseEntity<Void> deleteRole(@RequestBody @NotNull DeleteRolesRequest deleteRolesRequest) {
        Intrinsics.checkNotNullParameter((Object)deleteRolesRequest, (String)"deleteRolesRequest");
        this.getPermissionRepository().deleteByRoleKeyIn(deleteRolesRequest.getRoles());
        this.getRoleRepository().deleteByKeyIn(deleteRolesRequest.getRoles());
        ResponseEntity responseEntity = ResponseEntity.ok().build();
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok().build()");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/v1/roles/{roleKey}/permissions"})
    @JsonView(value={PermissionView.RoleManagement.class})
    @NotNull
    public ResponseEntity<List<PermissionDto>> getRolePermissions(@PathVariable @NotNull String roleKey) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)roleKey, (String)"roleKey");
        Iterable $this$map$iv = this.getPermissionRepository().findAllByRoleKeyInOrderByRoleKeyAscResourceTypeAsc(CollectionsKt.listOf((Object)roleKey));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Permission permission = (Permission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PermissionDto(it.getResourceType(), it.getAction().getKey(), it.getConditionContainer().getConditions(), it.getRole().getKey()));
        }
        List rolePermissions = (List)destination$iv$iv;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)rolePermissions);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(rolePermissions)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/v1/roles/{roleKey}/permissions"})
    @JsonView(value={PermissionView.RoleManagement.class})
    @Transactional
    @NotNull
    public ResponseEntity<List<PermissionDto>> updateRolePermissions(@PathVariable @NotNull String roleKey, @RequestBody @NotNull List<UpdateRolePermissionRequest> rolePermissions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)roleKey, (String)"roleKey");
        Intrinsics.checkNotNullParameter(rolePermissions, (String)"rolePermissions");
        Role role = this.getRoleRepository().findByKey(roleKey);
        Intrinsics.checkNotNull((Object)role);
        Role role2 = role;
        this.getPermissionRepository().deleteByRoleKeyIn(CollectionsKt.listOf((Object)roleKey));
        Iterable iterable = rolePermissions;
        Object object = this.getPermissionRepository();
        boolean $i$f$map22 = false;
        void var8_9 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            UpdateRolePermissionRequest updateRolePermissionRequest = (UpdateRolePermissionRequest)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AuthorizationSupportedHelper.INSTANCE.checkSupported(it.getResourceType());
            collection.add(it.toPermission(role2));
        }
        List list = object.saveAll((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"permissionRepository\n   \u2026          }\n            )");
        Iterable iterable2 = list;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (Permission)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new PermissionDto(it.getResourceType(), it.getAction().getKey(), it.getConditionContainer().getConditions(), it.getRole().getKey()));
        }
        List permissions = (List)destination$iv$iv2;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)permissions);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(permissions)");
        return responseEntity;
    }
}

