/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.audit;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ritense.valtimo.contract.utils.AssertionConcern;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
@JsonPropertyOrder(value={"id", "origin", "occurredOn", "user"})
public abstract class AuditMetaData {
    protected UUID id;
    protected String origin;
    protected LocalDateTime occurredOn;
    protected String user;

    @JsonCreator
    public AuditMetaData(UUID id, String origin, LocalDateTime occurredOn, String user) {
        AssertionConcern.assertArgumentNotNull(id, "id is required");
        AssertionConcern.assertArgumentNotNull(origin, "origin is required");
        AssertionConcern.assertArgumentNotNull(occurredOn, "occurredOn is required");
        AssertionConcern.assertArgumentNotNull(user, "user is required");
        this.id = id;
        this.origin = origin;
        this.occurredOn = occurredOn;
        this.user = user;
    }

    public AuditMetaData() {
    }

    public UUID getId() {
        return this.id;
    }

    public String getOrigin() {
        return this.origin;
    }

    public LocalDateTime getOccurredOn() {
        return this.occurredOn;
    }

    public String getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditMetaData)) {
            return false;
        }
        AuditMetaData that = (AuditMetaData)o;
        return this.getId().equals(that.getId()) && this.getOrigin().equals(that.getOrigin()) && this.getOccurredOn().equals(that.getOccurredOn()) && this.getUser().equals(that.getUser());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getOrigin(), this.getOccurredOn(), this.getUser());
    }
}

