/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.authentication.model;

import com.ritense.valtimo.contract.authentication.ManageableUser;
import java.util.List;
import java.util.Objects;
import org.springframework.util.ObjectUtils;

public class ValtimoUser
implements ManageableUser {
    private String id;
    private String username;
    private String name;
    private String email;
    private String firstName;
    private String lastName;
    private String phoneNo = "";
    private boolean isEmailVerified;
    private String langKey;
    private boolean blocked;
    private boolean activated;
    private List<String> roles;
    private String password;

    public void setId(String id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.isEmailVerified = emailVerified;
    }

    public void setLangKey(String langKey) {
        this.langKey = langKey;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getFullName() {
        if (ObjectUtils.isEmpty((Object)this.firstName) && ObjectUtils.isEmpty((Object)this.lastName)) {
            return "";
        }
        if (ObjectUtils.isEmpty((Object)this.firstName)) {
            return this.lastName;
        }
        if (ObjectUtils.isEmpty((Object)this.lastName)) {
            return this.firstName;
        }
        return this.firstName + " " + this.lastName;
    }

    @Override
    public String getLangKey() {
        return this.langKey;
    }

    @Override
    public String getPhoneNo() {
        return this.phoneNo;
    }

    @Override
    public boolean isEmailVerified() {
        return this.isEmailVerified;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void activate() {
        this.activated = true;
    }

    @Override
    public void deactivate() {
        this.activated = false;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValtimoUser)) {
            return false;
        }
        ValtimoUser that = (ValtimoUser)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.username, that.username) && Objects.equals(this.email, that.email);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.username, this.email);
    }
}

