/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.config;

import com.ritense.valtimo.contract.config.LiquibaseMasterChangeLogLocation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;

public class LiquibaseRunner {
    private static final Logger logger = LoggerFactory.getLogger(LiquibaseRunner.class);
    private final List<LiquibaseMasterChangeLogLocation> liquibaseMasterChangeLogLocations;
    private final Contexts context;
    private final DataSource datasource;

    public LiquibaseRunner(List<LiquibaseMasterChangeLogLocation> liquibaseMasterChangeLogLocations, LiquibaseProperties liquibaseProperties, DataSource datasource) {
        this.liquibaseMasterChangeLogLocations = liquibaseMasterChangeLogLocations;
        this.datasource = datasource;
        this.context = new Contexts(liquibaseProperties.getContexts());
    }

    public void run() throws SQLException, DatabaseException {
        Connection connection = this.datasource.getConnection();
        JdbcConnection jdbcConnection = new JdbcConnection(connection);
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
        try {
            for (LiquibaseMasterChangeLogLocation changeLogLocation : this.liquibaseMasterChangeLogLocations) {
                this.runChangeLog(database, changeLogLocation.getFilePath());
            }
        }
        catch (LiquibaseException liquibaseException) {
            throw new DatabaseException((Throwable)liquibaseException);
        }
        finally {
            try {
                connection.rollback();
                connection.close();
            }
            catch (SQLException sqlException) {
                logger.error("Error closing connection ", (Throwable)sqlException);
            }
        }
        logger.info("Finished running liquibase");
    }

    private void runChangeLog(Database database, String filePath) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(filePath, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        logger.info("Running liquibase master changelog: {}", (Object)liquibase.getChangeLogFile());
        liquibase.update(this.context);
    }
}

