/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

@ConstructorBinding
@ConfigurationProperties(prefix="valtimo")
public class ValtimoProperties {
    private final App app;
    private final Mandrill mandrill;
    private final Oauth oauth;
    private final Portal portal;
    private final Process process;

    public ValtimoProperties(App app, Mandrill mandrill, Oauth oauth, Portal portal, Process process) {
        this.app = app != null ? app : new App();
        this.mandrill = mandrill != null ? mandrill : new Mandrill();
        this.oauth = oauth != null ? oauth : new Oauth();
        this.portal = portal != null ? portal : new Portal();
        this.process = process != null ? process : new Process();
    }

    public App getApp() {
        return this.app;
    }

    public Mandrill getMandrill() {
        return this.mandrill;
    }

    public Oauth getOauth() {
        return this.oauth;
    }

    public Portal getPortal() {
        return this.portal;
    }

    public Process getProcess() {
        return this.process;
    }

    public static class App {
        private String hostname;
        private String scheme;

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getBaselUrl() {
            return String.format("%s://%s/", this.scheme, this.hostname);
        }
    }

    public static class Mandrill {
        private String apiKey;
        private String notificationTemplate;
        private String completionTemplate;
        private String reminderTemplate;
        private String sender;

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getNotificationTemplate() {
            return this.notificationTemplate;
        }

        public void setNotificationTemplate(String notificationTemplate) {
            this.notificationTemplate = notificationTemplate;
        }

        public String getCompletionTemplate() {
            return this.completionTemplate;
        }

        public void setCompletionTemplate(String completionTemplate) {
            this.completionTemplate = completionTemplate;
        }

        public String getReminderTemplate() {
            return this.reminderTemplate;
        }

        public void setReminderTemplate(String reminderTemplate) {
            this.reminderTemplate = reminderTemplate;
        }

        public String getSender() {
            return this.sender;
        }

        public void setSender(String sender) {
            this.sender = sender;
        }
    }

    public static class Oauth {
        private String publicKey;
        private long tokenValidityInSeconds = 180000L;

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public long getTokenValidityInSeconds() {
            return this.tokenValidityInSeconds;
        }

        public void setTokenValidityInSeconds(long tokenValidityInSeconds) {
            this.tokenValidityInSeconds = tokenValidityInSeconds;
        }
    }

    public static class Portal {
        private String hostname;
        private String scheme;

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getBaselUrl() {
            return String.format("%s://%s/", this.scheme, this.hostname);
        }
    }

    public static class Process {
        private boolean systemProcessUpdatable = false;

        public boolean isSystemProcessUpdatable() {
            return this.systemProcessUpdatable;
        }

        public void setSystemProcessUpdatable(boolean systemProcessUpdatable) {
            this.systemProcessUpdatable = systemProcessUpdatable;
        }
    }
}

