/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.database;

import com.ritense.valtimo.contract.database.QueryDialectHelper;
import java.time.temporal.TemporalAccessor;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public class MysqlQueryDialectHelper
implements QueryDialectHelper {
    private static final String LOWER_CASE_FUNCTION = "lower";

    @Override
    public <T> Expression<T> getJsonValueExpression(CriteriaBuilder cb, Path column, String path, Class<T> type) {
        Expression jsonValue = cb.function("JSON_EXTRACT", Object.class, new Expression[]{column, cb.literal((Object)path)});
        if (CharSequence.class.isAssignableFrom(type) || TemporalAccessor.class.isAssignableFrom(type)) {
            return cb.function("JSON_UNQUOTE", type, new Expression[]{jsonValue});
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return cb.function("IF", type, new Expression[]{jsonValue, cb.literal((Object)1), cb.literal((Object)0)});
        }
        return jsonValue.as(type);
    }

    @Override
    public Predicate getJsonValueExistsExpression(CriteriaBuilder cb, Path column, String value) {
        return cb.isNotNull(cb.function("JSON_SEARCH", String.class, new Expression[]{cb.function(LOWER_CASE_FUNCTION, String.class, new Expression[]{column}), cb.literal((Object)"all"), cb.function(LOWER_CASE_FUNCTION, String.class, new Expression[]{cb.literal((Object)("%" + value.trim() + "%"))})}));
    }

    @Override
    public Predicate getJsonValueExistsInPathExpression(CriteriaBuilder cb, Path column, String path, String value) {
        return cb.isNotNull(cb.function("JSON_SEARCH", String.class, new Expression[]{cb.function(LOWER_CASE_FUNCTION, String.class, new Expression[]{column}), cb.literal((Object)"all"), cb.function(LOWER_CASE_FUNCTION, String.class, new Expression[]{cb.literal((Object)("%" + value.trim() + "%"))}), cb.nullLiteral(String.class), cb.function(LOWER_CASE_FUNCTION, String.class, new Expression[]{cb.literal((Object)path)})}));
    }

    @Override
    public Predicate getJsonArrayContainsExpression(CriteriaBuilder cb, Path column, String path, String value) {
        return cb.isTrue(cb.function("JSON_CONTAINS", Boolean.class, new Expression[]{column, cb.function("JSON_QUOTE", Object.class, new Expression[]{cb.literal((Object)value)}), cb.literal((Object)path)}));
    }

    @Override
    public Expression<String> uuidToString(CriteriaBuilder cb, Path<UUID> column) {
        return cb.function("BIN_TO_UUID", String.class, new Expression[]{column});
    }
}

