/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.database;

import com.ritense.valtimo.contract.database.QueryDialectHelper;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public class PostgresQueryDialectHelper
implements QueryDialectHelper {
    private static final String LOWER_CASE_FUNCTION = "lower";

    @Override
    public <T> Expression<T> getJsonValueExpression(CriteriaBuilder cb, Path column, String jsonPath, Class<T> type) {
        Expression jsonValue = cb.function("jsonb_path_query_first", Object.class, new Expression[]{column, cb.function("jsonpath", String.class, new Expression[]{cb.literal((Object)jsonPath)})});
        if (String.class.isAssignableFrom(type)) {
            return cb.trim('\"', jsonValue.as(String.class)).as(type);
        }
        if (TemporalAccessor.class.isAssignableFrom(type)) {
            return cb.selectCase().when((Expression)jsonValue.as(String.class).in(new Object[]{"\"\""}), cb.nullLiteral(type)).otherwise(cb.trim('\"', jsonValue.as(String.class))).as(type);
        }
        if (Collection.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Failed to query '" + jsonPath + "'. Unsupported type '" + type + "'.");
        }
        return jsonValue.as(type);
    }

    @Override
    public Predicate getJsonValueExistsExpression(CriteriaBuilder cb, Path column, String value) {
        return cb.isTrue(cb.function("jsonb_path_exists", Boolean.class, new Expression[]{column, cb.function("jsonpath", String.class, new Expression[]{cb.literal((Object)("$.** ? (@ like_regex \"" + value + "\")"))})}));
    }

    @Override
    public Predicate getJsonValueExistsInPathExpression(CriteriaBuilder cb, Path column, String path, String value) {
        return cb.like(cb.function(LOWER_CASE_FUNCTION, String.class, new Expression[]{this.getValueForPathText(cb, column, path)}), "%" + value.toLowerCase() + "%");
    }

    @Override
    public Predicate getJsonArrayContainsExpression(CriteriaBuilder cb, Path column, String path, String value) {
        return cb.isTrue(cb.function("jsonb_contains_filter", Boolean.class, new Expression[]{cb.function("jsonb_path_query_first", Object.class, new Expression[]{column, cb.function("jsonpath", String.class, new Expression[]{cb.literal((Object)path)})}), cb.literal((Object)value)}));
    }

    @Override
    public Expression<String> uuidToString(CriteriaBuilder cb, Path<UUID> column) {
        return column.as(String.class);
    }

    private Expression<String> getValueForPathText(CriteriaBuilder cb, Path column, String path) {
        List<Expression> pathParts = this.splitPath(path).stream().map(arg_0 -> ((CriteriaBuilder)cb).literal(arg_0)).toList();
        Expression[] expressions = new Expression[pathParts.size() + 1];
        expressions[0] = column;
        System.arraycopy(pathParts.toArray(), 0, expressions, 1, pathParts.size());
        return cb.function("jsonb_extract_path_text", String.class, expressions);
    }

    private List<String> splitPath(String path) {
        String pathToSplit = path.startsWith("$.") ? path.substring(2) : path;
        return Arrays.asList(pathToSplit.split("\\."));
    }
}

