/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.document.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.ritense.valtimo.contract.audit.AuditEvent;
import com.ritense.valtimo.contract.audit.AuditMetaData;
import com.ritense.valtimo.contract.audit.view.AuditView;
import com.ritense.valtimo.contract.utils.AssertionConcern;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

public class DocumentRelatedFileAddedEvent
extends AuditMetaData
implements AuditEvent {
    private final UUID documentId;
    private final UUID fileId;
    private final String fileName;
    private final Map<String, Object> metadata;

    @JsonCreator
    public DocumentRelatedFileAddedEvent(UUID id, String origin, LocalDateTime occurredOn, String user, UUID documentId, UUID fileId, String fileName, Map<String, Object> metadata) {
        super(id, origin, occurredOn, user);
        AssertionConcern.assertArgumentNotNull(documentId, "documentId is required");
        AssertionConcern.assertArgumentNotNull(fileId, "fileId is required");
        AssertionConcern.assertArgumentNotNull(fileName, "fileName is required");
        this.documentId = documentId;
        this.fileId = fileId;
        this.fileName = fileName;
        this.metadata = metadata;
    }

    @Override
    @JsonView(value={AuditView.Internal.class})
    @JsonIgnore(value=false)
    public UUID getDocumentId() {
        return this.documentId;
    }

    public UUID getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }
}

