/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.document.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.ritense.valtimo.contract.audit.AuditEvent;
import com.ritense.valtimo.contract.audit.AuditMetaData;
import com.ritense.valtimo.contract.audit.view.AuditView;
import com.ritense.valtimo.contract.utils.AssertionConcern;
import java.time.LocalDateTime;
import java.util.UUID;

public class DocumentRelatedFileRemovedEvent
extends AuditMetaData
implements AuditEvent {
    private final UUID documentId;
    private final UUID fileId;
    private final String fileName;

    @JsonCreator
    public DocumentRelatedFileRemovedEvent(UUID id, String origin, LocalDateTime occurredOn, String user, UUID documentId, UUID fileId, String fileName) {
        super(id, origin, occurredOn, user);
        AssertionConcern.assertArgumentNotNull(documentId, "documentId is required");
        AssertionConcern.assertArgumentNotNull(fileId, "fileId is required");
        AssertionConcern.assertArgumentNotNull(fileName, "fileName is required");
        this.documentId = documentId;
        this.fileId = fileId;
        this.fileName = fileName;
    }

    @Override
    @JsonView(value={AuditView.Internal.class})
    @JsonIgnore(value=false)
    public UUID getDocumentId() {
        return this.documentId;
    }

    public UUID getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }
}

