/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.ritense.valtimo.contract.audit.AuditEvent;
import com.ritense.valtimo.contract.audit.AuditMetaData;
import com.ritense.valtimo.contract.audit.ProcessIdentity;
import com.ritense.valtimo.contract.audit.TaskFormerAssignee;
import com.ritense.valtimo.contract.audit.TaskIdentity;
import com.ritense.valtimo.contract.audit.TaskMetaData;
import com.ritense.valtimo.contract.utils.AssertionConcern;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

public class TaskAssignedEvent
extends AuditMetaData
implements AuditEvent,
TaskIdentity,
TaskMetaData,
ProcessIdentity,
TaskFormerAssignee {
    private String formerAssignee;
    private String assignee;
    private String taskId;
    private String taskName;
    private LocalDateTime taskCreatedOn;
    private String processDefinitionId;
    private String processInstanceId;
    private String businessKey;

    @JsonCreator
    public TaskAssignedEvent(UUID id, String origin, LocalDateTime occurredOn, String user, String formerAssignee, String assignee, String taskId, String taskName, LocalDateTime createdOn, String processDefinitionId, String processInstanceId, String businessKey) {
        super(id, origin, occurredOn, user);
        AssertionConcern.assertArgumentNotNull(assignee, "assignee is required");
        AssertionConcern.assertArgumentNotNull(createdOn, "createdOn is required");
        AssertionConcern.assertArgumentNotNull(taskId, "taskId is required");
        AssertionConcern.assertArgumentNotNull(taskName, "taskName is required");
        AssertionConcern.assertArgumentNotNull(processDefinitionId, "processDefinitionId is required");
        AssertionConcern.assertArgumentNotNull(processInstanceId, "processInstanceId is required");
        this.assignee = assignee;
        this.taskId = taskId;
        this.taskName = taskName;
        this.taskCreatedOn = createdOn;
        this.processDefinitionId = processDefinitionId;
        this.processInstanceId = processInstanceId;
        this.formerAssignee = formerAssignee;
        if (businessKey != null) {
            AssertionConcern.assertArgumentNotEmpty(businessKey, "businessKey cannot be empty");
            this.businessKey = businessKey;
        }
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getFormerAssignee() {
        return this.formerAssignee;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public LocalDateTime createdOn() {
        return this.taskCreatedOn;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    @Override
    public UUID getDocumentId() {
        try {
            return UUID.fromString(this.businessKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskAssignedEvent)) {
            return false;
        }
        TaskAssignedEvent that = (TaskAssignedEvent)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.getTaskId().equals(that.getTaskId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTaskId());
    }
}

