/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.ritense.valtimo.contract.audit.AuditEvent;
import com.ritense.valtimo.contract.audit.AuditMetaData;
import com.ritense.valtimo.contract.audit.ProcessIdentity;
import com.ritense.valtimo.contract.audit.TaskIdentity;
import com.ritense.valtimo.contract.audit.TaskMetaData;
import com.ritense.valtimo.contract.audit.VariableScope;
import com.ritense.valtimo.contract.utils.AssertionConcern;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

public class TaskCompletedEvent
extends AuditMetaData
implements AuditEvent,
TaskIdentity,
TaskMetaData,
ProcessIdentity,
VariableScope {
    private String assignee;
    private LocalDateTime createdOn;
    private String taskId;
    private String taskName;
    private String processDefinitionId;
    private String processInstanceId;
    private Map<String, Object> variables;
    private String businessKey;

    @JsonCreator
    public TaskCompletedEvent(UUID id, String origin, LocalDateTime occurredOn, String user, String assignee, LocalDateTime createdOn, String taskId, String taskName, String processDefinitionId, String processInstanceId, Map<String, Object> variables, String businessKey) {
        super(id, origin, occurredOn, user);
        AssertionConcern.assertArgumentNotNull(createdOn, "createdOn is required");
        AssertionConcern.assertArgumentNotNull(taskId, "taskId is required");
        AssertionConcern.assertArgumentNotNull(taskName, "taskName is required");
        AssertionConcern.assertArgumentNotNull(processDefinitionId, "processDefinitionId is required");
        AssertionConcern.assertArgumentNotNull(processInstanceId, "processInstanceId is required");
        this.assignee = assignee;
        this.createdOn = createdOn;
        this.taskId = taskId;
        this.taskName = taskName;
        this.processDefinitionId = processDefinitionId;
        this.processInstanceId = processInstanceId;
        this.variables = variables;
        if (businessKey != null) {
            AssertionConcern.assertArgumentNotEmpty(businessKey, "businessKey cannot be empty");
            this.businessKey = businessKey;
        }
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public LocalDateTime createdOn() {
        return this.createdOn;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    @Override
    public UUID getDocumentId() {
        try {
            return UUID.fromString(this.businessKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskCompletedEvent)) {
            return false;
        }
        TaskCompletedEvent that = (TaskCompletedEvent)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.taskId.equals(that.taskId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.taskId.hashCode();
        return result;
    }
}

