/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.hardening.service.impl;

import com.ritense.valtimo.contract.hardening.config.HardeningProperties;
import com.ritense.valtimo.contract.hardening.domain.SourceIpList;
import com.ritense.valtimo.contract.hardening.service.HardeningService;
import com.ritense.valtimo.contract.hardening.throwable.SanitizedThrowable;
import com.ritense.valtimo.contract.hardening.throwable.UnsanitizedThrowable;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.ThrowableProblem;

public class HardeningServiceImpl
implements HardeningService {
    private static final Logger logger = LoggerFactory.getLogger(HardeningServiceImpl.class);
    private final HardeningProperties hardeningProperties;
    private static String WHITELIST_MESSSAGE = "IP address is whitelisted: ";

    public HardeningServiceImpl(HardeningProperties hardeningProperties) {
        this.hardeningProperties = hardeningProperties;
    }

    @Override
    public Throwable harden(Throwable ex, HttpServletRequest request) {
        Set<String> whitelists = this.hardeningProperties.getAllowStacktraceOnIps();
        SourceIpList sourceIpList = new SourceIpList(whitelists, Set.of(request.getRemoteAddr()));
        if (sourceIpList.isWhitelisted()) {
            return UnsanitizedThrowable.withReason(ex, WHITELIST_MESSSAGE + sourceIpList.getWhiteListedIp());
        }
        return this.eraseStacktrace(ex);
    }

    @Override
    public ProblemBuilder harden(ThrowableProblem throwableProblem, ProblemBuilder problemBuilder, HttpServletRequest request) {
        Set<String> whitelists = this.hardeningProperties.getAllowStacktraceOnIps();
        SourceIpList sourceIpList = new SourceIpList(whitelists, Set.of(request.getRemoteAddr()));
        if (sourceIpList.isWhitelisted()) {
            return problemBuilder.with("reason-not-sanitized", (Object)(WHITELIST_MESSSAGE + sourceIpList.getWhiteListedIp())).with("stack-trace", (Object)throwableProblem.getStackTrace()).withDetail(throwableProblem.getDetail()).withCause(throwableProblem.getCause());
        }
        UUID referenceId = UUID.randomUUID();
        logger.info("Exception occurred with reference id {}", (Object)referenceId, (Object)throwableProblem);
        return problemBuilder.with("referenceId", (Object)referenceId);
    }

    protected <E extends Throwable> SanitizedThrowable eraseStacktrace(E ex) {
        SanitizedThrowable sanitizedThrowable;
        if (ex == null) {
            return null;
        }
        boolean exHasProperCause = ex.getCause() != null && !ex.getCause().equals(ex);
        String exCanonicalName = ex.getClass().getCanonicalName();
        String exMessage = ex.getMessage();
        if (exHasProperCause) {
            SanitizedThrowable sanitizedCause = this.eraseStacktrace(ex.getCause());
            sanitizedThrowable = SanitizedThrowable.withCause(exCanonicalName, exMessage, sanitizedCause);
        } else {
            sanitizedThrowable = SanitizedThrowable.withoutCause(exCanonicalName, exMessage);
        }
        return sanitizedThrowable;
    }
}

