/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.hardening.throwable;

public class SanitizedThrowable
extends Throwable {
    private final String originalExceptionName;

    private SanitizedThrowable(String originalExceptionName, String message, Throwable cause) {
        super(message, cause, true, true);
        this.originalExceptionName = originalExceptionName;
        this.setStackTrace(new StackTraceElement[0]);
    }

    @Override
    public String toString() {
        return this.originalExceptionName + ": " + this.getMessage();
    }

    public static SanitizedThrowable withoutCause(String originalExceptionName, String message) {
        return new SanitizedThrowable(originalExceptionName, message, null);
    }

    public static SanitizedThrowable withCause(String originalExceptionName, String message, SanitizedThrowable cause) {
        return new SanitizedThrowable(originalExceptionName, message, cause);
    }
}

