/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.json;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;

public abstract class JsonPointerHelper {
    public static void appendJsonPointerTo(ObjectNode node, JsonPointer pointer, JsonNode value) {
        JsonPointer parentPointer = pointer.head();
        JsonNode parentNode = node.at(parentPointer);
        String fieldName = pointer.last().toString().substring(1);
        if (parentNode.isMissingNode() || parentNode.isNull()) {
            parentNode = StringUtils.isNumeric((CharSequence)fieldName) ? JsonNodeFactory.instance.arrayNode() : JsonNodeFactory.instance.objectNode();
            JsonPointerHelper.appendJsonPointerTo(node, parentPointer, parentNode);
        }
        if (parentNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)parentNode;
            int index = Integer.parseInt(fieldName);
            for (int i = arrayNode.size(); i <= index; ++i) {
                arrayNode.addNull();
            }
            arrayNode.set(index, value);
        } else if (parentNode.isObject()) {
            ((ObjectNode)parentNode).set(fieldName, value);
        } else {
            throw new IllegalArgumentException(String.format("%s can't be set for parent node %s because parent is not a container but %s", fieldName, parentPointer, parentNode.getNodeType().name()));
        }
    }
}

