/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.json.patch;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.ritense.valtimo.contract.json.MapperSingleton;
import com.ritense.valtimo.contract.json.patch.JsonPatch;
import com.ritense.valtimo.contract.json.patch.operation.AddOperation;
import com.ritense.valtimo.contract.json.patch.operation.CopyOperation;
import com.ritense.valtimo.contract.json.patch.operation.JsonPatchOperation;
import com.ritense.valtimo.contract.json.patch.operation.MoveOperation;
import com.ritense.valtimo.contract.json.patch.operation.RemoveOperation;
import com.ritense.valtimo.contract.json.patch.operation.ReplaceOperation;
import java.util.LinkedHashSet;

public final class JsonPatchBuilder {
    private final LinkedHashSet<JsonPatchOperation> operations;

    public JsonPatchBuilder(LinkedHashSet<JsonPatchOperation> operations) {
        this.operations = operations;
    }

    public JsonPatchBuilder() {
        this.operations = new LinkedHashSet();
    }

    public JsonPatchBuilder add(JsonPointer path, JsonNode value) {
        this.operations.add(new AddOperation(path, value));
        return this;
    }

    public JsonPatchBuilder remove(JsonPointer path) {
        this.operations.add(new RemoveOperation(path));
        return this;
    }

    public JsonPatchBuilder replace(JsonPointer path, JsonNode value) {
        this.operations.add(new ReplaceOperation(path, value));
        return this;
    }

    public JsonPatchBuilder move(JsonPointer from, JsonPointer to) {
        this.operations.add(new MoveOperation(from, to));
        return this;
    }

    public JsonPatchBuilder copy(JsonPointer from, JsonPointer to) {
        this.operations.add(new CopyOperation(from, to));
        return this;
    }

    public JsonPatchBuilder addJsonNodeValue(JsonNode destination, JsonPointer path, JsonNode value) {
        JsonPointer workPath = this.determineUnindexedPath(destination, path);
        this.addJsonNodeValueInternal(destination, workPath, value);
        return this;
    }

    private JsonPointer determineUnindexedPath(JsonNode destination, JsonPointer path) {
        String stringPath = path.toString();
        int dashIndex = stringPath.indexOf("/-");
        if (dashIndex == -1) {
            return path;
        }
        String arrayPath = stringPath.substring(0, dashIndex);
        int i = 0;
        while (true) {
            String testPath = arrayPath + "/" + i;
            if (this.operations.stream().noneMatch(op -> op.getPath().equals(testPath)) && destination.at(testPath).isMissingNode()) {
                String correctedPath = testPath + stringPath.substring(dashIndex + 2).replace("/-", "/0");
                return JsonPointer.compile((String)correctedPath);
            }
            ++i;
        }
    }

    private void addJsonNodeValueInternal(JsonNode destination, JsonPointer path, JsonNode value) {
        JsonNode currentValue;
        if (destination.at(path.head()).isMissingNode()) {
            String propertyName = path.last().getMatchingProperty();
            Object newValue = propertyName.matches("\\d+") ? MapperSingleton.INSTANCE.get().createArrayNode() : MapperSingleton.INSTANCE.get().createObjectNode();
            this.addJsonNodeValueInternal(destination, path.head(), (JsonNode)newValue);
        }
        if ((currentValue = destination.at(path)).isMissingNode() || currentValue.isArray()) {
            this.add(path, value);
        } else {
            this.replace(path, value);
        }
    }

    public JsonPatch build() {
        return new JsonPatch(this.operations);
    }
}

