/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.json.patch.operation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonPointer;
import com.ritense.valtimo.contract.json.patch.operation.Operation;
import com.ritense.valtimo.contract.utils.AssertionConcern;
import java.util.Objects;

public abstract class JsonPatchOperation {
    private final Operation operation;
    private final JsonPointer path;

    protected JsonPatchOperation(Operation operation, JsonPointer path) {
        AssertionConcern.assertArgumentNotNull((Object)operation, "operation is required");
        AssertionConcern.assertArgumentNotNull(path, "path is required");
        this.operation = operation;
        this.path = path;
    }

    @JsonProperty(value="op")
    public String getOperation() {
        return this.operation.toString().toLowerCase();
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonPatchOperation)) {
            return false;
        }
        JsonPatchOperation that = (JsonPatchOperation)o;
        return this.operation == that.operation && this.path.equals((Object)that.path);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.path});
    }
}

