/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.mail.model;

import com.ritense.valtimo.contract.basictype.EmailAddress;
import java.util.Objects;

public class MailMessageStatus {
    private final EmailAddress email;
    private final String status;
    private final String rejectReason;
    private final String id;

    private MailMessageStatus(Builder builder) {
        this.email = builder.email;
        this.status = builder.status;
        this.rejectReason = builder.rejectReason;
        this.id = builder.id;
    }

    public static Builder with(EmailAddress email, String status, String id) {
        return new Builder(email, status, id);
    }

    public EmailAddress getEmail() {
        return this.email;
    }

    public String getStatus() {
        return this.status;
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public String getId() {
        return this.id;
    }

    public static class Builder {
        private final EmailAddress email;
        private final String status;
        private final String id;
        private String rejectReason = null;

        private Builder(EmailAddress email, String status, String id) {
            Objects.requireNonNull(email, "Email argument cannot be null");
            Objects.requireNonNull(status, "Status argument cannot be null");
            Objects.requireNonNull(id, "Id argument cannot be null");
            this.email = email;
            this.status = status;
            this.id = id;
        }

        public Builder rejectReason(String rejectReason) {
            Objects.requireNonNull(rejectReason, "Reject reason argument cannot be null");
            this.rejectReason = rejectReason;
            return this;
        }

        public MailMessageStatus build() {
            return new MailMessageStatus(this);
        }
    }
}

