/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.mail.model.value;

import com.ritense.valtimo.contract.mail.model.value.attachment.Content;
import com.ritense.valtimo.contract.mail.model.value.attachment.Name;
import com.ritense.valtimo.contract.mail.model.value.attachment.Type;
import java.util.Objects;

public class Attachment {
    public final Name name;
    public final Type type;
    public final Content content;

    private Attachment() {
        this.name = null;
        this.type = null;
        this.content = null;
    }

    private Attachment(Name name, Type type, Content content) {
        this.name = name;
        this.type = type;
        this.content = content;
    }

    public static Attachment from(Name name, Type type, Content content) {
        Objects.requireNonNull(name, "Attachment cannot be missing name");
        Objects.requireNonNull(type, "Attachment cannot be missing type");
        Objects.requireNonNull(content, "Attachment cannot be missing content data");
        name.assertPresentOrThrow("Attachment cannot be missing name");
        type.assertPresentOrThrow("Attachment cannot be missing type");
        content.assertPresentOrThrow("Attachment cannot be missing content");
        return new Attachment(name, type, content);
    }
}

