/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.mail.model.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ritense.valtimo.contract.basictype.Value;
import com.ritense.valtimo.contract.mail.model.value.Attachment;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class AttachmentCollection
extends Value<Collection<Attachment>> {
    private static final AttachmentCollection empty = new AttachmentCollection(null);

    @JsonCreator
    private AttachmentCollection(@JsonProperty(value="value") Collection<Attachment> value) {
        super(value);
    }

    public static AttachmentCollection from(Collection<Attachment> attachments) {
        Objects.requireNonNull(attachments, "Attachments cannot be empty");
        return new AttachmentCollection(Collections.unmodifiableCollection(attachments));
    }

    public static AttachmentCollection fromSingle(Attachment attachment) {
        Objects.requireNonNull(attachment, "Attachment cannot be empty");
        return new AttachmentCollection((Collection<Attachment>)Collections.singletonList(attachment));
    }

    public static AttachmentCollection empty() {
        return empty;
    }

    @Override
    public boolean isPresent() {
        return super.isPresent() && ((Collection)super.get()).size() > 0;
    }
}

