/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.mail.model.value;

import com.ritense.valtimo.contract.basictype.StringValue;
import java.util.Objects;

public class MailBody {
    public final MailBodyText textBody;
    public final MailBodyHtml htmlBody;

    private MailBody() {
        this.textBody = null;
        this.htmlBody = null;
    }

    private MailBody(MailBodyText textBody, MailBodyHtml htmlBody) {
        this.textBody = textBody;
        this.htmlBody = htmlBody;
    }

    public static MailBody of(MailBodyText mailBodyText) {
        return new MailBody(mailBodyText, MailBodyHtml.empty());
    }

    public static MailBody ofHtml(MailBodyHtml mailBodyHtml) {
        return new MailBody(MailBodyText.empty(), mailBodyHtml);
    }

    public static MailBody ofTextAndHtml(MailBodyText mailBodyText, MailBodyHtml mailBodyHtml) {
        Objects.requireNonNull(mailBodyText, "Cannot create MailBody with a 'null' MailBodyText");
        Objects.requireNonNull(mailBodyHtml, "Cannot create MailBody with a 'null' MailBodyHtml");
        return new MailBody(mailBodyText, mailBodyHtml);
    }

    public static class MailBodyText
    extends StringValue {
        private static final MailBodyText empty = new MailBodyText(null);

        private MailBodyText(String value) {
            super(value);
        }

        @Override
        public boolean isPresent() {
            return this.value != null;
        }

        public static MailBodyText of(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot create MailBodyText from a null, use MailBodyText.none() instead");
            }
            return new MailBodyText(value);
        }

        public static MailBodyText empty() {
            return empty;
        }
    }

    public static class MailBodyHtml
    extends StringValue {
        private static final MailBodyHtml empty = new MailBodyHtml(null);

        private MailBodyHtml(String value) {
            super(value);
        }

        @Override
        public boolean isPresent() {
            return this.value != null;
        }

        public static MailBodyHtml of(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot create MailBodyHtml from a null, use MailBodyHtml.none() instead");
            }
            return new MailBodyHtml(value);
        }

        public static MailBodyHtml empty() {
            return empty;
        }
    }
}

