/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.mail.model.value;

import com.ritense.valtimo.contract.basictype.EmailAddress;
import com.ritense.valtimo.contract.basictype.SimpleName;
import java.util.Objects;

public class Recipient {
    public final EmailAddress email;
    public final SimpleName name;
    public final Type type;

    private Recipient() {
        this.email = null;
        this.name = null;
        this.type = null;
    }

    private Recipient(EmailAddress email, SimpleName name, Type type) {
        this.email = email;
        this.name = name;
        this.type = type;
    }

    public static Recipient to(EmailAddress emailAddress, SimpleName name) {
        return Recipient.forType(emailAddress, name, Type.TO);
    }

    public static Recipient cc(EmailAddress emailAddress, SimpleName name) {
        return Recipient.forType(emailAddress, name, Type.CC);
    }

    public static Recipient bcc(EmailAddress emailAddress, SimpleName name) {
        return Recipient.forType(emailAddress, name, Type.BCC);
    }

    public String toString() {
        return "Recipient{email=" + this.email + ", name=" + this.name + ", type=" + this.type + "}";
    }

    private static Recipient forType(EmailAddress emailAddress, SimpleName name, Type type) {
        Objects.requireNonNull(emailAddress, "Recipient cannot be missing an email address");
        emailAddress.assertPresentOrThrow("Recipient cannot be missing an email address");
        return new Recipient(emailAddress, name, type);
    }

    public static enum Type {
        TO,
        CC,
        BCC;

    }
}

