/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.mail.model.value;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ritense.valtimo.contract.basictype.Value;
import com.ritense.valtimo.contract.mail.model.value.Recipient;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RecipientCollection
extends Value<Collection<Recipient>> {
    @JsonCreator
    private RecipientCollection(@JsonProperty(value="value") Collection<Recipient> value) {
        super(value);
    }

    public static RecipientCollection from(Collection<Recipient> recipients) {
        Objects.requireNonNull(recipients, "Cannot create value collection from a 'null' collection");
        return new RecipientCollection(Collections.unmodifiableCollection(recipients));
    }

    public static RecipientCollection fromSingle(Recipient recipient) {
        Objects.requireNonNull(recipient, "Cannot create value collection from a 'null' Recipient");
        return new RecipientCollection((Collection<Recipient>)Collections.singletonList(recipient));
    }

    public Collection<Recipient> filterTo() {
        return this.filterType(Recipient.Type.TO);
    }

    public Collection<Recipient> filterCc() {
        return this.filterType(Recipient.Type.CC);
    }

    public Collection<Recipient> filterBcc() {
        return this.filterType(Recipient.Type.BCC);
    }

    public String toString() {
        return ((Collection)this.value).stream().map(Recipient::toString).collect(Collectors.joining(", "));
    }

    @Override
    public boolean isPresent() {
        return super.isPresent() && ((Collection)super.get()).size() > 0;
    }

    private Collection<Recipient> filterType(Recipient.Type typeToFilterOn) {
        return ((Collection)this.value).stream().filter(x -> x.type == typeToFilterOn).collect(Collectors.toList());
    }

    public void filterBy(Predicate<Recipient> predicate) {
        this.value = ((Collection)this.value).stream().filter(predicate).collect(Collectors.toList());
    }
}

