/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.result;

import com.ritense.valtimo.contract.result.OperationError;
import com.ritense.valtimo.contract.utils.AssertionConcern;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface FunctionResult<T, E extends OperationError> {
    public Optional<T> resultingValue();

    public List<E> errors();

    default public boolean hasResult() {
        return this.resultingValue().isPresent();
    }

    default public boolean isError() {
        return !this.hasResult();
    }

    public static class Erroneous<T>
    implements FunctionResult<T, OperationError> {
        private final List<OperationError> errors;

        public Erroneous(OperationError error) {
            this(List.of(error));
        }

        Erroneous(List<OperationError> errors) {
            AssertionConcern.assertArgumentNotNull(errors, "errors may not be null");
            AssertionConcern.assertStateTrue(errors.size() > 0, "errors may not be empty");
            this.errors = errors;
        }

        @Override
        public Optional<T> resultingValue() {
            return Optional.empty();
        }

        @Override
        public List<OperationError> errors() {
            return this.errors;
        }

        @Override
        public boolean hasResult() {
            return false;
        }
    }

    public static class Successful<T>
    implements FunctionResult<T, OperationError> {
        private final T resultingValue;

        public Successful(T resultingValue) {
            AssertionConcern.assertArgumentNotNull(resultingValue, "resultingValue is required");
            this.resultingValue = resultingValue;
        }

        @Override
        public Optional<T> resultingValue() {
            return Optional.of(this.resultingValue);
        }

        @Override
        public List<OperationError> errors() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasResult() {
            return true;
        }
    }
}

