/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.utils;

public class AssertionConcern {
    public void assertArgumentEquals(Object firstObject, Object secondObject, String message) {
        if (!firstObject.equals(secondObject)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentFalse(boolean value, String message) {
        if (value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentLength(String value, int maximum, String message) {
        int length = value.trim().length();
        if (length > maximum) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentLength(String value, int minimum, int maximum, String message) {
        int length = value.trim().length();
        if (length < minimum || length > maximum) {
            throw new IllegalArgumentException(message + " - value '" + value + "'");
        }
    }

    public static void assertArgumentNotEmpty(String value, String message) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentNotEquals(Object firstObject, Object secondObject, String message) {
        if (firstObject.equals(secondObject)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentNotNull(Object anObject, String message) {
        if (anObject == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentNull(Object anObject, String message) {
        if (anObject != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentRange(double value, double minimum, double maximum, String message) {
        if (value < minimum || value > maximum) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentRange(float value, float minimum, float maximum, String message) {
        if (value < minimum || value > maximum) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentRange(int value, int minimum, int maximum, String message) {
        if (value < minimum || value > maximum) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentRange(long value, long minimum, long maximum, String message) {
        if (value < minimum || value > maximum) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertArgumentTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertStateFalse(boolean value, String message) {
        if (value) {
            throw new IllegalStateException(message);
        }
    }

    public static void assertStateTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalStateException(message);
        }
    }
}

