/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.utils;

import com.ritense.valtimo.contract.utils.IpUtils;
import java.time.ZoneOffset;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(RequestHelper.class);

    public static String getOrigin() {
        Set<String> ipList;
        try {
            HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            ipList = IpUtils.extractSourceIpsFrom(httpServletRequest);
        }
        catch (Exception e) {
            ipList = Set.of("unknown");
        }
        return ipList.toString();
    }

    public static ZoneOffset getZoneOffset() {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        try {
            HttpServletRequest request;
            String zoneOffsetHeader;
            RequestAttributes attribs = RequestContextHolder.getRequestAttributes();
            if (attribs != null && StringUtils.isNotBlank((CharSequence)(zoneOffsetHeader = (request = ((ServletRequestAttributes)attribs).getRequest()).getHeader("X-Timezone-Offset")))) {
                zoneOffset = ZoneOffset.of(zoneOffsetHeader);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return zoneOffset;
    }
}

