/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static String getCurrentUserLogin() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        String userName = null;
        if (authentication != null) {
            userName = authentication.getName();
        }
        return userName;
    }

    public static boolean isCurrentUserInRole(String authority) {
        return SecurityUtils.getCurrentUserRoles().contains(authority);
    }

    public static List<String> getCurrentUserRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        }
        return roles;
    }

    public static Collection<? extends GrantedAuthority> getCurrentUserRoles(String login) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            return securityContext.getAuthentication().getAuthorities();
        }
        return null;
    }

    public static boolean isAuthenticated() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return false;
        }
        Collection authorities = authentication.getAuthorities();
        if (authorities != null) {
            for (GrantedAuthority authority : authorities) {
                if (!authority.getAuthority().equals("ROLE_ANONYMOUS")) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<? extends GrantedAuthority> getCurrentUserAuthorities() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            return authentication.getAuthorities();
        }
        return null;
    }

    public static Authentication getCurrentUserAuthentication() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return securityContext.getAuthentication();
    }
}

