/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valtimo.contract.web.rest.error;

import com.ritense.valtimo.contract.hardening.service.HardeningService;
import com.ritense.valtimo.contract.web.rest.error.ErrorConstants;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.ProblemHandling;
import org.zalando.problem.violations.ConstraintViolationProblem;

@ControllerAdvice
public class ExceptionTranslator
implements ProblemHandling {
    private final Optional<HardeningService> hardeningServiceOptional;

    public ExceptionTranslator(Optional<HardeningService> hardeningServiceOptional) {
        this.hardeningServiceOptional = hardeningServiceOptional;
    }

    public ResponseEntity<Problem> process(@Nullable ResponseEntity<Problem> entity, NativeWebRequest request) {
        if (entity == null) {
            return entity;
        }
        Problem problem = (Problem)entity.getBody();
        if (!(problem instanceof ConstraintViolationProblem) && !(problem instanceof DefaultProblem)) {
            return entity;
        }
        ProblemBuilder builder = Problem.builder().withType(Problem.DEFAULT_TYPE.equals(problem.getType()) ? ErrorConstants.DEFAULT_TYPE : problem.getType()).withStatus(problem.getStatus()).withTitle(problem.getTitle());
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        if (httpServletRequest != null) {
            builder.with("path", (Object)httpServletRequest.getRequestURI());
        }
        String MESSAGE = "message";
        if (problem instanceof ConstraintViolationProblem) {
            builder.with("violations", (Object)((ConstraintViolationProblem)problem).getViolations()).with(MESSAGE, (Object)"error.validation");
        } else {
            builder.withInstance(problem.getInstance());
            problem.getParameters().forEach((arg_0, arg_1) -> ((ProblemBuilder)builder).with(arg_0, arg_1));
            if (!problem.getParameters().containsKey(MESSAGE) && problem.getStatus() != null) {
                builder.with(MESSAGE, (Object)("error.http." + problem.getStatus().getStatusCode()));
            }
        }
        builder.withCause(((DefaultProblem)problem).getCause());
        this.hardeningServiceOptional.ifPresent(hardeningService -> hardeningService.harden((ThrowableProblem)problem, builder, (HttpServletRequest)request.getNativeRequest()));
        return new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
    }
}

