/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.mail.autoconfigure;

import com.ritense.mail.MailDispatcher;
import com.ritense.mail.config.MailingProperties;
import com.ritense.mail.domain.filters.BlacklistFilter;
import com.ritense.mail.domain.filters.RedirectToFilter;
import com.ritense.mail.domain.filters.WhitelistFilter;
import com.ritense.mail.repository.BlacklistRepository;
import com.ritense.mail.service.BlacklistService;
import com.ritense.mail.service.FilteredMailSender;
import com.ritense.mail.service.MailService;
import com.ritense.valtimo.contract.annotation.ProcessBean;
import com.ritense.valtimo.contract.mail.MailFilter;
import com.ritense.valtimo.contract.mail.MailSender;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableConfigurationProperties(value={MailingProperties.class})
@EnableJpaRepositories(basePackages={"com.ritense.mail.repository"})
@EntityScan(value={"com.ritense.mail.domain"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0017J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0019"}, d2={"Lcom/ritense/mail/autoconfigure/MailAutoConfiguration;", "", "()V", "blacklistFilter", "Lcom/ritense/mail/domain/filters/BlacklistFilter;", "mailingProperties", "Lcom/ritense/mail/config/MailingProperties;", "blacklistService", "Lcom/ritense/mail/service/BlacklistService;", "blacklistRepository", "Lcom/ritense/mail/repository/BlacklistRepository;", "filteredMailService", "Lcom/ritense/valtimo/contract/mail/MailSender;", "mailDispatcher", "Lcom/ritense/mail/MailDispatcher;", "filters", "", "Lcom/ritense/valtimo/contract/mail/MailFilter;", "mailService", "Lcom/ritense/mail/service/MailService;", "mailSender", "redirectToFilter", "Lcom/ritense/mail/domain/filters/RedirectToFilter;", "whitelistFilter", "Lcom/ritense/mail/domain/filters/WhitelistFilter;", "mail"})
public class MailAutoConfiguration {
    @Bean
    @ProcessBean
    @ConditionalOnMissingBean(value={MailService.class})
    @NotNull
    public MailService mailService(@NotNull MailSender mailSender) {
        Intrinsics.checkNotNullParameter((Object)mailSender, (String)"mailSender");
        return new MailService(mailSender);
    }

    @Bean
    @ConditionalOnMissingBean(value={MailSender.class})
    @NotNull
    public MailSender filteredMailService(@NotNull MailDispatcher mailDispatcher, @NotNull Collection<? extends MailFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)mailDispatcher, (String)"mailDispatcher");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new FilteredMailSender(mailDispatcher, filters);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlacklistService.class})
    @NotNull
    public BlacklistService blacklistService(@NotNull BlacklistRepository blacklistRepository) {
        Intrinsics.checkNotNullParameter((Object)blacklistRepository, (String)"blacklistRepository");
        return new BlacklistService(blacklistRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlacklistFilter.class})
    @NotNull
    public BlacklistFilter blacklistFilter(@NotNull MailingProperties mailingProperties, @NotNull BlacklistService blacklistService) {
        Intrinsics.checkNotNullParameter((Object)mailingProperties, (String)"mailingProperties");
        Intrinsics.checkNotNullParameter((Object)blacklistService, (String)"blacklistService");
        return new BlacklistFilter(mailingProperties, blacklistService);
    }

    @Bean
    @ConditionalOnMissingBean(value={RedirectToFilter.class})
    @NotNull
    public RedirectToFilter redirectToFilter(@NotNull MailingProperties mailingProperties) {
        Intrinsics.checkNotNullParameter((Object)mailingProperties, (String)"mailingProperties");
        return new RedirectToFilter(mailingProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={WhitelistFilter.class})
    @NotNull
    public WhitelistFilter whitelistFilter(@NotNull MailingProperties mailingProperties) {
        Intrinsics.checkNotNullParameter((Object)mailingProperties, (String)"mailingProperties");
        return new WhitelistFilter(mailingProperties);
    }
}

