/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.mail.domain.filters;

import com.ritense.mail.config.MailingProperties;
import com.ritense.mail.service.BlacklistService;
import com.ritense.valtimo.contract.mail.MailFilter;
import com.ritense.valtimo.contract.mail.model.RawMailMessage;
import com.ritense.valtimo.contract.mail.model.TemplatedMailMessage;
import com.ritense.valtimo.contract.mail.model.value.Recipient;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ritense/mail/domain/filters/BlacklistFilter;", "Lcom/ritense/valtimo/contract/mail/MailFilter;", "mailingProperties", "Lcom/ritense/mail/config/MailingProperties;", "blacklistService", "Lcom/ritense/mail/service/BlacklistService;", "(Lcom/ritense/mail/config/MailingProperties;Lcom/ritense/mail/service/BlacklistService;)V", "doFilter", "Ljava/util/Optional;", "Lcom/ritense/valtimo/contract/mail/model/RawMailMessage;", "rawMailMessage", "Lcom/ritense/valtimo/contract/mail/model/TemplatedMailMessage;", "templatedMailMessage", "getPriority", "", "isEnabled", "", "mail"})
public final class BlacklistFilter
implements MailFilter {
    @NotNull
    private final MailingProperties mailingProperties;
    @NotNull
    private final BlacklistService blacklistService;

    public BlacklistFilter(@NotNull MailingProperties mailingProperties, @NotNull BlacklistService blacklistService) {
        Intrinsics.checkNotNullParameter((Object)mailingProperties, (String)"mailingProperties");
        Intrinsics.checkNotNullParameter((Object)blacklistService, (String)"blacklistService");
        this.mailingProperties = mailingProperties;
        this.blacklistService = blacklistService;
    }

    @NotNull
    public Optional<RawMailMessage> doFilter(@NotNull RawMailMessage rawMailMessage) {
        Intrinsics.checkNotNullParameter((Object)rawMailMessage, (String)"rawMailMessage");
        rawMailMessage.recipients.filterBy(arg_0 -> BlacklistFilter.doFilter$lambda$0(this, arg_0));
        Optional<RawMailMessage> optional = Optional.of(rawMailMessage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(rawMailMessage)");
        return optional;
    }

    @NotNull
    public Optional<TemplatedMailMessage> doFilter(@NotNull TemplatedMailMessage templatedMailMessage) {
        Intrinsics.checkNotNullParameter((Object)templatedMailMessage, (String)"templatedMailMessage");
        templatedMailMessage.recipients.filterBy(arg_0 -> BlacklistFilter.doFilter$lambda$1(this, arg_0));
        Optional<TemplatedMailMessage> optional = Optional.of(templatedMailMessage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(templatedMailMessage)");
        return optional;
    }

    public boolean isEnabled() {
        return this.mailingProperties.getBlacklistFilter();
    }

    public int getPriority() {
        return this.mailingProperties.getBlacklistFilterPriority();
    }

    private static final boolean doFilter$lambda$0(BlacklistFilter this$0, Recipient it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BlacklistService blacklistService = this$0.blacklistService;
        Object object = it.email.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.email.get()");
        return !blacklistService.isBlacklisted((String)object);
    }

    private static final boolean doFilter$lambda$1(BlacklistFilter this$0, Recipient it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BlacklistService blacklistService = this$0.blacklistService;
        Object object = it.email.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.email.get()");
        return !blacklistService.isBlacklisted((String)object);
    }
}

