/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.mail.service;

import com.ritense.mail.domain.blacklist.BlacklistedEmail;
import com.ritense.mail.repository.BlacklistRepository;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ritense/mail/service/BlacklistService;", "", "blacklistRepository", "Lcom/ritense/mail/repository/BlacklistRepository;", "(Lcom/ritense/mail/repository/BlacklistRepository;)V", "blacklist", "", "emailAddress", "", "blacklistedOn", "Ljava/time/LocalDateTime;", "cause", "isBlacklisted", "", "mail"})
public final class BlacklistService {
    @NotNull
    private final BlacklistRepository blacklistRepository;

    public BlacklistService(@NotNull BlacklistRepository blacklistRepository) {
        Intrinsics.checkNotNullParameter((Object)blacklistRepository, (String)"blacklistRepository");
        this.blacklistRepository = blacklistRepository;
    }

    public final void blacklist(@NotNull String emailAddress, @NotNull LocalDateTime blacklistedOn, @NotNull String cause) {
        Intrinsics.checkNotNullParameter((Object)emailAddress, (String)"emailAddress");
        Intrinsics.checkNotNullParameter((Object)blacklistedOn, (String)"blacklistedOn");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (!this.isBlacklisted(emailAddress)) {
            this.blacklistRepository.save(new BlacklistedEmail(emailAddress, blacklistedOn, cause));
        }
    }

    public final boolean isBlacklisted(@NotNull String emailAddress) {
        Intrinsics.checkNotNullParameter((Object)emailAddress, (String)"emailAddress");
        return this.blacklistRepository.existsById(emailAddress);
    }
}

