/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.mail.service;

import com.ritense.mail.MailDispatcher;
import com.ritense.mail.service.FilteredMailSender;
import com.ritense.valtimo.contract.mail.MailFilter;
import com.ritense.valtimo.contract.mail.MailSender;
import com.ritense.valtimo.contract.mail.model.MailMessageStatus;
import com.ritense.valtimo.contract.mail.model.RawMailMessage;
import com.ritense.valtimo.contract.mail.model.TemplatedMailMessage;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\t2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/ritense/mail/service/FilteredMailSender;", "Lcom/ritense/valtimo/contract/mail/MailSender;", "mailDispatcher", "Lcom/ritense/mail/MailDispatcher;", "filters", "", "Lcom/ritense/valtimo/contract/mail/MailFilter;", "(Lcom/ritense/mail/MailDispatcher;Ljava/util/Collection;)V", "applyFilters", "Ljava/util/Optional;", "Lcom/ritense/valtimo/contract/mail/model/RawMailMessage;", "rawMailMessage", "Lcom/ritense/valtimo/contract/mail/model/TemplatedMailMessage;", "templatedMailMessage", "getMaximumSizeAttachments", "", "prioritizedFilters", "send", "", "Lcom/ritense/valtimo/contract/mail/model/MailMessageStatus;", "mail"})
@SourceDebugExtension(value={"SMAP\nFilteredMailSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilteredMailSender.kt\ncom/ritense/mail/service/FilteredMailSender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1855#2,2:93\n1855#2,2:95\n*S KotlinDebug\n*F\n+ 1 FilteredMailSender.kt\ncom/ritense/mail/service/FilteredMailSender\n*L\n60#1:93,2\n74#1:95,2\n*E\n"})
public final class FilteredMailSender
implements MailSender {
    @NotNull
    private final MailDispatcher mailDispatcher;
    @NotNull
    private final Collection<MailFilter> filters;

    public FilteredMailSender(@NotNull MailDispatcher mailDispatcher, @NotNull Collection<? extends MailFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)mailDispatcher, (String)"mailDispatcher");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        this.mailDispatcher = mailDispatcher;
        this.filters = filters;
    }

    @NotNull
    public Optional<List<MailMessageStatus>> send(@NotNull RawMailMessage rawMailMessage) {
        Intrinsics.checkNotNullParameter((Object)rawMailMessage, (String)"rawMailMessage");
        Optional<RawMailMessage> optionalMessage = this.applyFilters(rawMailMessage);
        if (optionalMessage.isPresent()) {
            Optional<List<MailMessageStatus>> optional = Optional.of(this.mailDispatcher.send(rawMailMessage));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(mailDispatcher.send(rawMailMessage))");
            return optional;
        }
        Optional<List<MailMessageStatus>> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        return optional;
    }

    @NotNull
    public Optional<List<MailMessageStatus>> send(@NotNull TemplatedMailMessage templatedMailMessage) {
        Intrinsics.checkNotNullParameter((Object)templatedMailMessage, (String)"templatedMailMessage");
        Optional<TemplatedMailMessage> optionalMessage = this.applyFilters(templatedMailMessage);
        if (optionalMessage.isPresent()) {
            Optional<List<MailMessageStatus>> optional = Optional.of(this.mailDispatcher.send(templatedMailMessage));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(mailDispatcher.send(templatedMailMessage))");
            return optional;
        }
        Optional<List<MailMessageStatus>> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        return optional;
    }

    public int getMaximumSizeAttachments() {
        return this.mailDispatcher.getMaximumSizeAttachments();
    }

    private final Optional<RawMailMessage> applyFilters(RawMailMessage rawMailMessage) {
        Object filteredRawMailMessage = null;
        filteredRawMailMessage = rawMailMessage;
        Collection<MailFilter> filters = this.prioritizedFilters();
        Iterable $this$forEach$iv = filters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MailFilter it = (MailFilter)element$iv;
            boolean bl = false;
            Optional filteredMailMessageOptional = it.doFilter(filteredRawMailMessage);
            if (filteredMailMessageOptional.isPresent()) {
                Intrinsics.checkNotNullExpressionValue(filteredMailMessageOptional.get(), (String)"filteredMailMessageOptional.get()");
                continue;
            }
            Optional<RawMailMessage> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            return optional;
        }
        Optional<RawMailMessage> optional = Optional.of(filteredRawMailMessage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(filteredRawMailMessage)");
        return optional;
    }

    private final Optional<TemplatedMailMessage> applyFilters(TemplatedMailMessage templatedMailMessage) {
        Object filteredTemplatedMailMessage = null;
        filteredTemplatedMailMessage = templatedMailMessage;
        Collection<MailFilter> filters = this.prioritizedFilters();
        Iterable $this$forEach$iv = filters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MailFilter it = (MailFilter)element$iv;
            boolean bl = false;
            Optional filteredMailMessageOptional = it.doFilter(filteredTemplatedMailMessage);
            if (filteredMailMessageOptional.isPresent()) {
                Intrinsics.checkNotNullExpressionValue(filteredMailMessageOptional.get(), (String)"filteredMailMessageOptional.get()");
                continue;
            }
            Optional<TemplatedMailMessage> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            return optional;
        }
        Optional<TemplatedMailMessage> optional = Optional.of(filteredTemplatedMailMessage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(filteredTemplatedMailMessage)");
        return optional;
    }

    private final Collection<MailFilter> prioritizedFilters() {
        List<Object> list = this.filters.stream().filter(arg_0 -> FilteredMailSender.prioritizedFilters$lambda$2(prioritizedFilters.1.INSTANCE, arg_0)).sorted(new Comparator(){

            public final int compare(T a, T b) {
                MailFilter it = (MailFilter)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (MailFilter)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        }).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"filters.stream()\n       \u2026 })\n            .toList()");
        return list;
    }

    private static final boolean prioritizedFilters$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

