/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.mail.service;

import com.ritense.valtimo.contract.basictype.EmailAddress;
import com.ritense.valtimo.contract.basictype.SimpleName;
import com.ritense.valtimo.contract.mail.MailSender;
import com.ritense.valtimo.contract.mail.model.MailMessageStatus;
import com.ritense.valtimo.contract.mail.model.TemplatedMailMessage;
import com.ritense.valtimo.contract.mail.model.value.MailTemplateIdentifier;
import com.ritense.valtimo.contract.mail.model.value.Recipient;
import com.ritense.valtimo.contract.mail.model.value.Sender;
import com.ritense.valtimo.contract.mail.model.value.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ritense/mail/service/MailService;", "", "mailSender", "Lcom/ritense/valtimo/contract/mail/MailSender;", "(Lcom/ritense/valtimo/contract/mail/MailSender;)V", "getMailSettings", "Lcom/ritense/mail/service/MailService$MailSettings;", "delegateExecution", "Lorg/camunda/bpm/engine/delegate/DelegateExecution;", "parseValue", "", "value", "sendElementTemplateTaskMail", "Ljava/util/Optional;", "", "Lcom/ritense/valtimo/contract/mail/model/MailMessageStatus;", "MailSettings", "mail"})
@SourceDebugExtension(value={"SMAP\nMailService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MailService.kt\ncom/ritense/mail/service/MailService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n766#2:115\n857#2,2:116\n1253#2,4:118\n*S KotlinDebug\n*F\n+ 1 MailService.kt\ncom/ritense/mail/service/MailService\n*L\n53#1:115\n53#1:116,2\n54#1:118,4\n*E\n"})
public final class MailService {
    @NotNull
    private final MailSender mailSender;

    public MailService(@NotNull MailSender mailSender) {
        Intrinsics.checkNotNullParameter((Object)mailSender, (String)"mailSender");
        this.mailSender = mailSender;
    }

    @Nullable
    public final Optional<List<MailMessageStatus>> sendElementTemplateTaskMail(@NotNull DelegateExecution delegateExecution) {
        Intrinsics.checkNotNullParameter((Object)delegateExecution, (String)"delegateExecution");
        MailSettings mailSettings = this.getMailSettings(delegateExecution);
        return this.mailSender.send(mailSettings.getTemplatedMailMessage());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MailSettings getMailSettings(@NotNull DelegateExecution delegateExecution) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)delegateExecution, (String)"delegateExecution");
        Map camundaPropertiesMap = new LinkedHashMap();
        Collection collection = ((CamundaProperties)delegateExecution.getBpmnModelElementInstance().getExtensionElements().getElementsQuery().filterByType(CamundaProperties.class).singleResult()).getCamundaProperties();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"delegateExecution\n      \u2026       .camundaProperties");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CamundaProperty it = (CamundaProperty)element$iv$iv;
            boolean bl = false;
            if (!(it.getCamundaName() != null && it.getCamundaValue() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateTo$iv = (List)destination$iv$iv;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map = camundaPropertiesMap;
            CamundaProperty it = (CamundaProperty)element$iv;
            boolean bl = false;
            String string = it.getAttributeValue("name");
            String string2 = it.getCamundaValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.camundaValue");
            Pair pair = TuplesKt.to((Object)string, (Object)this.parseValue(string2, delegateExecution));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return new MailSettings(camundaPropertiesMap, delegateExecution);
    }

    private final String parseValue(String value, DelegateExecution delegateExecution) {
        String string;
        Matcher camundaExpressionMatcher = MailSettings.Companion.getCamundaExpressionPattern().matcher(value);
        if (camundaExpressionMatcher.find()) {
            String keyNameFromExpression = camundaExpressionMatcher.group(1);
            Object v = delegateExecution.getVariables().get(keyNameFromExpression);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)v;
        } else {
            string = value;
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B#\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J+\u0010\u001c\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e*\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u000e*\u0004\b\u0010\u0010\fR\u001b\u0010\u0012\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u000e*\u0004\b\u0013\u0010\fR\u001b\u0010\u0015\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u000e*\u0004\b\u0016\u0010\fR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/ritense/mail/service/MailService$MailSettings;", "", "map", "", "", "delegateExecution", "Lorg/camunda/bpm/engine/delegate/DelegateExecution;", "(Ljava/util/Map;Lorg/camunda/bpm/engine/delegate/DelegateExecution;)V", "getDelegateExecution", "()Lorg/camunda/bpm/engine/delegate/DelegateExecution;", "mailSendTaskFrom", "getMailSendTaskFrom$delegate", "(Lcom/ritense/mail/service/MailService$MailSettings;)Ljava/lang/Object;", "getMailSendTaskFrom", "()Ljava/lang/String;", "mailSendTaskSubject", "getMailSendTaskSubject$delegate", "getMailSendTaskSubject", "mailSendTaskTemplate", "getMailSendTaskTemplate$delegate", "getMailSendTaskTemplate", "mailSendTaskTo", "getMailSendTaskTo$delegate", "getMailSendTaskTo", "getMap", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "getPlaceholders", "getRecipient", "Lcom/ritense/valtimo/contract/mail/model/value/Recipient;", "getSender", "Lcom/ritense/valtimo/contract/mail/model/value/Sender;", "getSubject", "Lcom/ritense/valtimo/contract/mail/model/value/Subject;", "getTemplatedMailMessage", "Lcom/ritense/valtimo/contract/mail/model/TemplatedMailMessage;", "hashCode", "", "toString", "Companion", "mail"})
    public static final class MailSettings {
        @NotNull
        public static final Companion Companion;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final Map<String, Object> map;
        @NotNull
        private final DelegateExecution delegateExecution;
        @NotNull
        private static final Pattern camundaExpressionPattern;

        public MailSettings(@NotNull Map<String, ? extends Object> map, @NotNull DelegateExecution delegateExecution) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)delegateExecution, (String)"delegateExecution");
            this.map = map;
            this.delegateExecution = delegateExecution;
        }

        @NotNull
        public final Map<String, Object> getMap() {
            return this.map;
        }

        @NotNull
        public final DelegateExecution getDelegateExecution() {
            return this.delegateExecution;
        }

        @NotNull
        public final String getMailSendTaskTo() {
            Map<String, Object> map = this.map;
            return (String)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[0].getName());
        }

        private static Object getMailSendTaskTo$delegate(MailSettings mailSettings) {
            return mailSettings.map;
        }

        @NotNull
        public final String getMailSendTaskFrom() {
            Map<String, Object> map = this.map;
            return (String)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[1].getName());
        }

        private static Object getMailSendTaskFrom$delegate(MailSettings mailSettings) {
            return mailSettings.map;
        }

        @NotNull
        public final String getMailSendTaskSubject() {
            Map<String, Object> map = this.map;
            return (String)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[2].getName());
        }

        private static Object getMailSendTaskSubject$delegate(MailSettings mailSettings) {
            return mailSettings.map;
        }

        @NotNull
        public final String getMailSendTaskTemplate() {
            Map<String, Object> map = this.map;
            return (String)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[3].getName());
        }

        private static Object getMailSendTaskTemplate$delegate(MailSettings mailSettings) {
            return mailSettings.map;
        }

        @NotNull
        public final Recipient getRecipient() {
            Recipient recipient = Recipient.to((EmailAddress)EmailAddress.from((String)this.getMailSendTaskTo()), (SimpleName)SimpleName.none());
            Intrinsics.checkNotNullExpressionValue((Object)recipient, (String)"to(EmailAddress.from(mai\u2026skTo), SimpleName.none())");
            return recipient;
        }

        @NotNull
        public final Sender getSender() {
            Sender sender = Sender.from((EmailAddress)EmailAddress.from((String)this.getMailSendTaskFrom()));
            Intrinsics.checkNotNullExpressionValue((Object)sender, (String)"from(EmailAddress.from(mailSendTaskFrom))");
            return sender;
        }

        @NotNull
        public final Subject getSubject() {
            Subject subject = Subject.from((String)this.getMailSendTaskSubject());
            Intrinsics.checkNotNullExpressionValue((Object)subject, (String)"from(mailSendTaskSubject)");
            return subject;
        }

        @NotNull
        public final Map<String, Object> getPlaceholders() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"business-key", (Object)this.delegateExecution.getProcessBusinessKey()), TuplesKt.to((Object)"var", (Object)this.delegateExecution.getVariables())};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public final TemplatedMailMessage getTemplatedMailMessage() {
            TemplatedMailMessage templatedMailMessage = TemplatedMailMessage.with((Recipient)this.getRecipient(), (MailTemplateIdentifier)MailTemplateIdentifier.from((String)this.getMailSendTaskTemplate())).placeholders(this.getPlaceholders()).subject(this.getSubject()).sender(this.getSender()).build();
            Intrinsics.checkNotNullExpressionValue((Object)templatedMailMessage, (String)"with(getRecipient(), Mai\u2026\n                .build()");
            return templatedMailMessage;
        }

        @NotNull
        public final Map<String, Object> component1() {
            return this.map;
        }

        @NotNull
        public final DelegateExecution component2() {
            return this.delegateExecution;
        }

        @NotNull
        public final MailSettings copy(@NotNull Map<String, ? extends Object> map, @NotNull DelegateExecution delegateExecution) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)delegateExecution, (String)"delegateExecution");
            return new MailSettings(map, delegateExecution);
        }

        public static /* synthetic */ MailSettings copy$default(MailSettings mailSettings, Map map, DelegateExecution delegateExecution, int n, Object object) {
            if ((n & 1) != 0) {
                map = mailSettings.map;
            }
            if ((n & 2) != 0) {
                delegateExecution = mailSettings.delegateExecution;
            }
            return mailSettings.copy(map, delegateExecution);
        }

        @NotNull
        public String toString() {
            return "MailSettings(map=" + this.map + ", delegateExecution=" + this.delegateExecution + ")";
        }

        public int hashCode() {
            int result = ((Object)this.map).hashCode();
            result = result * 31 + this.delegateExecution.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MailSettings)) {
                return false;
            }
            MailSettings mailSettings = (MailSettings)other;
            if (!Intrinsics.areEqual(this.map, mailSettings.map)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.delegateExecution, (Object)mailSettings.delegateExecution);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MailSettings.class, "mailSendTaskTo", "getMailSendTaskTo()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MailSettings.class, "mailSendTaskFrom", "getMailSendTaskFrom()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MailSettings.class, "mailSendTaskSubject", "getMailSendTaskSubject()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MailSettings.class, "mailSendTaskTemplate", "getMailSendTaskTemplate()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
            Companion = new Companion(null);
            Pattern pattern = Pattern.compile("^\\$\\{([a-zA-Z0-9_\\-\\.]+)\\}$");
            Intrinsics.checkNotNull((Object)pattern);
            camundaExpressionPattern = pattern;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ritense/mail/service/MailService$MailSettings$Companion;", "", "()V", "camundaExpressionPattern", "Ljava/util/regex/Pattern;", "getCamundaExpressionPattern", "()Ljava/util/regex/Pattern;", "mail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Pattern getCamundaExpressionPattern() {
                return camundaExpressionPattern;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

