/*
 * Decompiled with CFR 0.152.
 */
package com.ritense.valueresolver.autoconfiguration;

import com.ritense.valueresolver.FixedValueResolverFactory;
import com.ritense.valueresolver.ProcessVariableValueResolverFactory;
import com.ritense.valueresolver.ValueResolverFactory;
import com.ritense.valueresolver.ValueResolverService;
import com.ritense.valueresolver.ValueResolverServiceImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.bpm.engine.RuntimeService;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\b\u0010\u0005\u001a\u00020\u0004H\u0017J\b\u0010\u0006\u001a\u00020\u0004H\u0017J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0017\u00a8\u0006\u000e"}, d2={"Lcom/ritense/valueresolver/autoconfiguration/ValueResolverAutoConfiguration;", "", "()V", "fixedValueResolver", "Lcom/ritense/valueresolver/ValueResolverFactory;", "httpValueResolver", "httpsValueResolver", "processVariableValueResolver", "runtimeService", "Lorg/camunda/bpm/engine/RuntimeService;", "valueResolverService", "Lcom/ritense/valueresolver/ValueResolverService;", "valueResolverFactories", "", "value-resolver"})
public class ValueResolverAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ValueResolverService.class})
    @NotNull
    public ValueResolverService valueResolverService(@Lazy @NotNull List<? extends ValueResolverFactory> valueResolverFactories) {
        Intrinsics.checkNotNullParameter(valueResolverFactories, (String)"valueResolverFactories");
        return new ValueResolverServiceImpl(valueResolverFactories);
    }

    @Bean
    @ConditionalOnMissingBean(name={"fixedValueResolver"})
    @NotNull
    public ValueResolverFactory fixedValueResolver() {
        return new FixedValueResolverFactory(null, 1, null);
    }

    @Bean
    @ConditionalOnMissingBean(name={"httpValueResolver"})
    @NotNull
    public ValueResolverFactory httpValueResolver() {
        return new FixedValueResolverFactory("http");
    }

    @Bean
    @ConditionalOnMissingBean(name={"httpsValueResolver"})
    @NotNull
    public ValueResolverFactory httpsValueResolver() {
        return new FixedValueResolverFactory("https");
    }

    @Bean
    @ConditionalOnBean(value={RuntimeService.class})
    @ConditionalOnMissingBean(value={ProcessVariableValueResolverFactory.class})
    @NotNull
    public ValueResolverFactory processVariableValueResolver(@NotNull RuntimeService runtimeService) {
        Intrinsics.checkNotNullParameter((Object)runtimeService, (String)"runtimeService");
        return new ProcessVariableValueResolverFactory(runtimeService);
    }
}

