/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.dbusjava.nativefd;

import com.rm5248.dbusjava.nativefd.MsgHdr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageProtocolVersionException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MessageFactory;
import org.freedesktop.dbus.spi.IMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMessageReader
implements IMessageReader {
    private static POSIX POSIX = POSIXFactory.getPOSIX();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Logger logger_native = LoggerFactory.getLogger((String)(NativeMessageReader.class.getName() + ".native"));
    private int m_fd;
    private boolean m_isClosed;
    private int m_nativeHandle;

    public NativeMessageReader(int fd) {
        this.m_fd = fd;
        this.m_isClosed = false;
        this.m_nativeHandle = this.openNativeHandle(this.m_fd);
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public Message readMessage() throws IOException, DBusException {
        Message m;
        int totalMessageLen;
        MsgHdr h = this.readNative(this.m_nativeHandle);
        this.logger.debug("Got the data");
        ByteBuffer inData = ByteBuffer.wrap(h.getMessages().get(0));
        byte endian = inData.get(0);
        byte type = inData.get(1);
        byte protover = inData.get(3);
        if (protover > 1) {
            throw new MessageProtocolVersionException(String.format("Protocol version %s is unsupported", protover));
        }
        if (endian == 66) {
            inData.order(ByteOrder.BIG_ENDIAN);
        } else if (endian == 108) {
            inData.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.logger.error("Incorrect endian {}", (Object)endian);
            throw new IOException("incorrect endianess");
        }
        IntBuffer asInt = inData.asIntBuffer();
        int messageBodyLen = asInt.get(1);
        int headerArrayLen = asInt.get(3);
        if (0 != headerArrayLen % 8) {
            headerArrayLen += 8 - headerArrayLen % 8;
        }
        if ((totalMessageLen = 12 + (4 + headerArrayLen) + messageBodyLen) != h.getMessages().get(0).length) {
            throw new IOException("Incorrect length of data read from JNI");
        }
        byte[] header1 = new byte[12];
        byte[] arrayHeader = new byte[headerArrayLen + 8];
        byte[] body = new byte[messageBodyLen];
        inData = ByteBuffer.wrap(h.getMessages().get(0));
        inData.get(header1);
        inData.get(arrayHeader, 0, 4);
        inData.get(arrayHeader, 8, arrayHeader.length - 8);
        inData.get(body);
        try {
            m = MessageFactory.createMessage((byte)type, (byte[])header1, (byte[])arrayHeader, (byte[])body, h.getFileDescriptors());
        }
        catch (DBusException dbe) {
            this.logger.debug("", (Throwable)dbe);
            throw dbe;
        }
        catch (RuntimeException exRe) {
            this.logger.debug("", (Throwable)exRe);
            throw exRe;
        }
        this.logger.debug("=> {}", (Object)m);
        return m;
    }

    public void close() throws IOException {
        if (this.m_isClosed) {
            return;
        }
        this.m_isClosed = true;
        POSIX.close(this.m_fd);
        this.closeNativeHandle(this.m_nativeHandle);
    }

    private native int openNativeHandle(int var1);

    private native void closeNativeHandle(int var1);

    private native MsgHdr readNative(int var1) throws IOException;
}

