/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.dbusjava.nativefd;

import com.rm5248.dbusjava.nativefd.NativeMessageReader;
import com.rm5248.dbusjava.nativefd.NativeMessageWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import jnr.unixsocket.UnixSocketChannel;
import org.freedesktop.dbus.spi.IMessageReader;
import org.freedesktop.dbus.spi.IMessageWriter;
import org.freedesktop.dbus.spi.ISocketProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeSocketProvider
implements ISocketProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)NativeSocketProvider.class.getName());
    private boolean m_hasFiledescriptorSupport;
    private NativeMessageReader m_nativeMessageReader;
    private NativeMessageWriter m_nativeMessageWriter;

    public NativeSocketProvider() {
        logger.debug("new NativeSocketProvider");
        this.m_hasFiledescriptorSupport = false;
    }

    public IMessageReader createReader(Socket _socket) throws IOException {
        if (!this.m_hasFiledescriptorSupport) {
            return null;
        }
        SocketChannel sc = _socket.getChannel();
        if (sc instanceof UnixSocketChannel) {
            int fd = ((UnixSocketChannel)sc).getFD();
            this.m_nativeMessageReader = new NativeMessageReader(fd);
            return this.m_nativeMessageReader;
        }
        return null;
    }

    public IMessageWriter createWriter(Socket _socket) throws IOException {
        if (!this.m_hasFiledescriptorSupport) {
            return null;
        }
        SocketChannel sc = _socket.getChannel();
        if (sc instanceof UnixSocketChannel) {
            int fd = ((UnixSocketChannel)sc).getFD();
            this.m_nativeMessageWriter = new NativeMessageWriter(fd);
            return this.m_nativeMessageWriter;
        }
        return null;
    }

    public void setFileDescriptorSupport(boolean _support) {
        this.m_hasFiledescriptorSupport = _support;
    }

    public boolean isFileDescriptorPassingSupported() {
        return true;
    }

    private static void loadNativeLibrary() {
        String nativeLibraryPath = System.getProperty("com.rm5248.dbusnative.lib.path");
        String nativeLibraryName = System.getProperty("com.rm5248.dbusnative.lib.name");
        if (nativeLibraryName == null) {
            nativeLibraryName = System.mapLibraryName("dbus-java-jni-connector");
            if (nativeLibraryName.endsWith("dylib")) {
                nativeLibraryName = nativeLibraryName.replace("dylib", "jnilib");
            }
            logger.debug("No native library name provided, using default of {}", (Object)nativeLibraryName);
        }
        if (nativeLibraryPath != null) {
            logger.debug("Native library path of {} provided", (Object)nativeLibraryPath);
            File libToLoad = new File(nativeLibraryPath, nativeLibraryName);
            logger.debug("Loading library {}", (Object)libToLoad.getAbsolutePath());
            System.load(libToLoad.getAbsolutePath());
            return;
        }
        try {
            String osName = System.getProperty("os.name");
            osName = osName.contains("Windows") ? "Windows" : (osName.contains("Mac") || osName.contains("Darwin") ? "Mac" : (osName.contains("Linux") ? "Linux" : osName.replaceAll("\\W", "")));
            String arch = System.getProperty("os.arch");
            arch.replaceAll("\\W", "");
            if (arch.equals("x86_64")) {
                arch = "amd64";
            }
            Path tempFolder = Files.createTempDirectory("dbus-java", new FileAttribute[0]);
            tempFolder.toFile().deleteOnExit();
            logger.debug("Created temp folder of {}", (Object)tempFolder);
            File extractedLib = new File(tempFolder.toFile(), nativeLibraryName);
            String fileToExtract = "/" + osName + "/" + arch + "/" + nativeLibraryName;
            logger.debug("About to extract {} from JAR", (Object)fileToExtract);
            InputStream library = NativeSocketProvider.class.getResourceAsStream(fileToExtract);
            if (library == null) {
                throw new UnsatisfiedLinkError("Unable to extract native library from JAR:" + fileToExtract + ".");
            }
            Files.copy(library, extractedLib.toPath(), new CopyOption[0]);
            extractedLib.deleteOnExit();
            System.load(extractedLib.getAbsolutePath());
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError("Unable to create temp directory or extract: " + e.getMessage());
        }
    }

    static {
        NativeSocketProvider.loadNativeLibrary();
    }
}

