/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.util.Log;
import android.util.Pair;
import com.googlecode.tesseract.android.PageIterator;
import java.util.ArrayList;
import java.util.List;

public class ResultIterator
extends PageIterator {
    private final long mNativeResultIterator;

    ResultIterator(long nativeResultIterator) {
        super(nativeResultIterator);
        this.mNativeResultIterator = nativeResultIterator;
    }

    public String getUTF8Text(int level) {
        return ResultIterator.nativeGetUTF8Text(this.mNativeResultIterator, level);
    }

    public float confidence(int level) {
        return ResultIterator.nativeConfidence(this.mNativeResultIterator, level);
    }

    public List<Pair<String, Double>> getChoicesAndConfidence(int level) {
        String[] nativeChoices = ResultIterator.nativeGetChoices(this.mNativeResultIterator, level);
        ArrayList<Pair<String, Double>> pairedResults = new ArrayList<Pair<String, Double>>();
        for (String nativeChoice : nativeChoices) {
            String utfString;
            int separatorPosition = nativeChoice.lastIndexOf(124);
            Double confidenceLevel = 0.0;
            if (separatorPosition > 0) {
                utfString = nativeChoice.substring(0, separatorPosition);
                try {
                    confidenceLevel = Double.parseDouble(nativeChoice.substring(separatorPosition + 1));
                }
                catch (NumberFormatException e) {
                    Log.e((String)"ResultIterator", (String)("Invalid confidence level for " + nativeChoice));
                }
            } else {
                utfString = nativeChoice;
            }
            pairedResults.add((Pair<String, Double>)new Pair((Object)utfString, (Object)confidenceLevel));
        }
        return pairedResults;
    }

    public void delete() {
        ResultIterator.nativeDelete(this.mNativeResultIterator);
    }

    private static native String[] nativeGetChoices(long var0, int var2);

    private static native String nativeGetUTF8Text(long var0, int var2);

    private static native float nativeConfidence(long var0, int var2);

    private static native void nativeDelete(long var0);

    static {
        System.loadLibrary("jpgt");
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
        System.loadLibrary("tess");
    }
}

