/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class Scale {
    public static Pix scaleToSize(Pix pixs, int width, int height, ScaleType type) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int pixWidth = pixs.getWidth();
        int pixHeight = pixs.getHeight();
        float scaleX = (float)width / (float)pixWidth;
        float scaleY = (float)height / (float)pixHeight;
        switch (type) {
            case FILL: {
                break;
            }
            case FIT: {
                scaleY = scaleX = Math.min(scaleX, scaleY);
                break;
            }
            case FIT_SHRINK: {
                scaleY = scaleX = Math.min(1.0f, Math.min(scaleX, scaleY));
            }
        }
        return Scale.scale(pixs, scaleX, scaleY);
    }

    public static Pix scale(Pix pixs, float scale) {
        return Scale.scale(pixs, scale, scale);
    }

    public static Pix scaleWithoutSharpening(Pix pixs, float scale) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (scale <= 0.0f) {
            throw new IllegalArgumentException("Scaling factor must be positive");
        }
        return new Pix(Scale.nativeScaleGeneral(pixs.getNativePix(), scale, scale, 0.0f, 0));
    }

    public static Pix scale(Pix pixs, float scaleX, float scaleY) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (scaleX <= 0.0f) {
            throw new IllegalArgumentException("X scaling factor must be positive");
        }
        if (scaleY <= 0.0f) {
            throw new IllegalArgumentException("Y scaling factor must be positive");
        }
        long nativePix = Scale.nativeScale(pixs.getNativePix(), scaleX, scaleY);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to natively scale pix");
        }
        return new Pix(nativePix);
    }

    private static native long nativeScale(long var0, float var2, float var3);

    private static native long nativeScaleGeneral(long var0, float var2, float var3, float var4, int var5);

    static {
        System.loadLibrary("jpgt");
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
    }

    public static enum ScaleType {
        FILL,
        FIT,
        FIT_SHRINK;

    }
}

